/*********************************************************************************
 * Copyright (c) 2007 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

package de.fzj.unicore.cisprovider.sensors;

import de.fzj.unicore.cisprovider.CIPProperties;
import de.fzj.unicore.cisprovider.Topics;
import de.fzj.unicore.cisprovider.impl.DefaultMonitoringEvent;
import de.fzj.unicore.cisprovider.impl.DefaultSensor;
import de.fzj.unicore.cisprovider.impl.UrlExtractor;
import de.fzj.unicore.cisprovider.xmlbeans.SiteDocument;
import de.fzj.unicore.cisprovider.xmlbeans.SiteDocument.Site;
import de.fzj.unicore.wsrflite.Kernel;

public class SiteInfo extends DefaultSensor {
	
	@Override
	public String getName() {
		return "SiteInfo";
	}

	public SiteInfo(Kernel kernel){
		super(kernel);
		setLastEvent(createEvent());
	}
	
	protected DefaultMonitoringEvent createEvent(){
		DefaultMonitoringEvent e=new DefaultMonitoringEvent();
		e.setDescription("This contains general information about the site");
		e.setTopic(Topics.SITE+"/General");
		e.setTitle("Site information");
		e.setDetails(makeDetailedSiteInfo());
		if(getLastEvent()!=null)e.setSupersedes(getLastEvent().getID());
		return e;
	}
	
	/**
	 * create the detailed information about the site
	 */
	protected SiteDocument makeDetailedSiteInfo(){
		SiteDocument sd=SiteDocument.Factory.newInstance();
		Site s=sd.addNewSite();
		CIPProperties cfg = kernel.getAttribute(CIPProperties.class);
		
		s.addNewGeoData().setLatitude(cfg.getValue(CIPProperties.LATITUDE));
		s.getGeoData().setLongitude(cfg.getValue(CIPProperties.LONGITUDE));

		String baseUrl = kernel.getContainerProperties().getBaseUrl();
		String serviceUrl = baseUrl + "/TargetSystemFactory";
		
		String name = cfg.getValue(CIPProperties.NAME);
		if (name == null)
			name=UrlExtractor.generateSiteName(baseUrl);
		s.setName(name);
		
		// Monitor service url
		String url = cfg.getValue(CIPProperties.URL);
		if (url == null)
			url = serviceUrl;
		s.setURL(url);
		
		s.setNumberOfCPUs(cfg.getIntValue(CIPProperties.NUM_CPUS));
		s.setDescription(cfg.getValue(CIPProperties.DESCRIPTION));		
		return sd;
	}
	
	
	
}
