/*********************************************************************************
 * Copyright (c) 2007 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

package de.fzj.unicore.cisprovider.sensors;

import java.util.Calendar;
import java.util.concurrent.TimeUnit;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlString;

import de.fzj.unicore.cisprovider.CIPConstants;
import de.fzj.unicore.cisprovider.Topics;
import de.fzj.unicore.cisprovider.impl.DefaultMonitoringEvent;
import de.fzj.unicore.cisprovider.impl.DefaultSensor;
import de.fzj.unicore.wsrflite.Kernel;

public class Heartbeat extends DefaultSensor implements Runnable{
	
	private static final Logger logger = Logger.getLogger(CIPConstants.LOG_PREFIX+Heartbeat.class.getSimpleName());    
	
	/**
	 * default heartbeat interval in seconds
	 */
	private static final int DEFAULT_INTERVAL=5*60;
	
	private Calendar upSince;
	
	private int interval;
	
	public Heartbeat(Kernel kernel){
		this(kernel,DEFAULT_INTERVAL);
	}

	public Heartbeat(Kernel kernel, int interval){
		super(kernel);
		this.interval=interval;
		init();
	}

	protected void init(){
		upSince=Calendar.getInstance();
		kernel.getContainerProperties().getThreadingServices().getScheduledExecutorService().
				scheduleWithFixedDelay(this, interval, interval, TimeUnit.SECONDS);
		logger.info("Configured heartbeat at interval of "+interval+" seconds.");
		setLastEvent(createEvent());
	}

	protected XmlString getUpSince(){
		XmlString s=XmlString.Factory.newInstance();
		s.setStringValue(upSince.getTime().toString());
		return s;
	}

	protected DefaultMonitoringEvent createEvent(){
		DefaultMonitoringEvent e=new DefaultMonitoringEvent();
		e.setDescription("This periodic heartbeat event is published every ["+interval+"] second(s).");
		e.setDetails(getUpSince());
		e.setTopic(Topics.SITE+"/Heartbeat");
		e.setTitle("Heartbeat event");
		if(getLastEvent()!=null)e.setSupersedes(getLastEvent().getID());
		return e;
	}
	
	/**
	 * Name of this sensor
	 */
	public String getName(){
		return "Heartbeat";
	}
	
	/**
	 * action taken periodically
	 */
	public void run(){
		DefaultMonitoringEvent e=createEvent();
		setLastEvent(e);
		doNotify();
	}

	
	
}
