package de.fzj.unicore.cisprovider.sensors;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;

import de.fzj.unicore.cisprovider.Topics;
import de.fzj.unicore.cisprovider.impl.DefaultMonitoringEvent;
import de.fzj.unicore.cisprovider.impl.DefaultSensor;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import eu.unicore.security.Client;

/** 
 * Sensor for executions system information events 
 */
public class ExecutionEnvironmentInfo extends DefaultSensor{

	@Override
	public String getName() {
		return "ExecutionEnvironmentInfo";
	}
	public ExecutionEnvironmentInfo(Kernel kernel) {
		super(kernel);
		setLastEvent(createEvent());
	}
	protected DefaultMonitoringEvent createEvent(){
		DefaultMonitoringEvent e=new DefaultMonitoringEvent();
		e.setDescription("This contains execution environment information at  particular computing site");
		e.setTopic(Topics.EXECUTION+"/General");
		e.setTitle("Execution environment information");
		e.setDetails(makeDetailedSiteInfo());
		if(getLastEvent()!=null)e.setSupersedes(getLastEvent().getID());
		return e;
	}
	private ResourcesDocument makeDetailedSiteInfo() {
		ResourcesType rt = XNJSFacade.get(null,kernel).getResources(new Client());
		ResourcesDocument rd = ResourcesDocument.Factory.newInstance();
		rd.addNewResources();
		rd.setResources(rt);		
		return rd;
	}
	

}
