package de.fzj.unicore.cisprovider.sensors;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;

import de.fzj.unicore.cisprovider.Topics;
import de.fzj.unicore.cisprovider.impl.DefaultMonitoringEvent;
import de.fzj.unicore.cisprovider.impl.DefaultSensor;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;

/** 
 * Sensor for generation application information events 
 */
public class ApplicationsInfo extends DefaultSensor{

	@Override
	public String getName() {
		return "ApplicationsInfo";
	}
	
	public ApplicationsInfo(Kernel kernel) {
		super(kernel);
		setLastEvent(createEvent());
	}
	
	protected DefaultMonitoringEvent createEvent(){
		DefaultMonitoringEvent e=new DefaultMonitoringEvent();
		e.setDescription("This contains Applications installed at computing site");
		e.setTopic(Topics.APPLICATIONS+"/General");
		e.setTitle("Applications information");
		e.setDetailsArray(makeDetailedSiteInfo());
		if(getLastEvent()!=null)e.setSupersedes(getLastEvent().getID());
		return e;
	}

	@Deprecated
	private ApplicationType[] makeDetailedSiteInfo() {
		ApplicationType[] appsType = XNJSFacade.get(null,kernel).getDefinedApplicationTypes();
		return appsType;
	}
	

}
