package de.fzj.unicore.cisprovider.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import de.fzj.unicore.cisprovider.CIPConstants;

public class UrlExtractor {
	private static String UrlRe = "://(\\S+):(\\d+)/([^/]*)";

	public static Map<String, String> extractUrl(String url) {
		Map<String, String> extractedMap = new HashMap<String, String>();
		Pattern p = Pattern.compile(UrlRe, Pattern.CASE_INSENSITIVE);
		Matcher m = p.matcher(url);

		while (m.find()) {
			extractedMap.put(CIPConstants.HOSTNAME, m.group(1));
			extractedMap.put(CIPConstants.PORT, m.group(2));
			if (!m.group(3).contains("services")) {
				extractedMap.put(CIPConstants.SITENAME, m.group(3));
			} else {
				extractedMap.put(CIPConstants.SITENAME,
						"DEFAULT-SITE");
			}

		}

		return extractedMap;

	}

	public static String generateUniqueSiteName(Map<String, String> map) {
		String str = "";
		for (String s : map.values()) {
			str += s + ".";
		}
		return str.substring(0, str.lastIndexOf('.'));
	}

	public static String generateUniqueSiteName(String url) {
		Map<String, String> map = extractUrl(url);
		String str = map.get(CIPConstants.HOSTNAME) + "$"
				+ map.get(CIPConstants.PORT) + "$"
				+ map.get(CIPConstants.SITENAME);
		return str;
	}
	
	public static String generateSiteName(String url) {
		Map<String, String> map = extractUrl(url);
		String str = map.get(CIPConstants.SITENAME) + " at " +
		map.get(CIPConstants.HOSTNAME) + ":"
				+ map.get(CIPConstants.PORT) 
				;
		return str;
	}
}
