/*********************************************************************************
 * Copyright (c) 2007 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

package de.fzj.unicore.cisprovider.impl;

import java.util.Calendar;
import java.util.List;

import org.apache.xmlbeans.XmlString;
import org.w3.x2005.atom.EntryType;
import org.w3.x2005.atom.FeedDocument;
import org.w3.x2005.atom.FeedType;

import de.fzj.unicore.cisprovider.MonitoringEvent;
import de.fzj.unicore.wsrflite.Kernel;

public class FeedGenerator {
	
	private FeedGenerator(){}
	
	/**
	 * Generate an Atom Feed document from a list of {@link MonitoringEvent}s
	 * using a {@link DefaultEventConverter} to generate the feed entries
	 * 
	 * @param events
	 * @return an Atom feed
	 */
	public static FeedDocument generateFeed(List<MonitoringEvent> events, Kernel kernel){
		return generateFeed(events, new DefaultEventConverter(), kernel);
	}
	
	/**
	 * Generate an Atom Feed document from a list of {@link MonitoringEvent}s
	 * 
	 * @param events - the list of events
	 * @param converter - the {@link EventToFeedEntryConverter} to use
	 * @return an Atom feed
	 */
	public static FeedDocument generateFeed(List<MonitoringEvent> events, EventToFeedEntryConverter conv, Kernel kernel){
		FeedDocument f=FeedDocument.Factory.newInstance();
		FeedType ft=f.addNewFeed();
		XmlString t=XmlString.Factory.newInstance();
		t.setStringValue("Feed generated by UNICORE CIS InfoProvider");
		ft.addNewTitle().set(t);
		ft.addNewUpdated().setCalendarValue(Calendar.getInstance());
		ft.addNewId().setStringValue(kernel.getContainerProperties().getBaseUrl());
		for(MonitoringEvent e: events){
			ft.addNewEntry().set(conv.createFeedEntry(e,kernel));
		}
		return f;
	}
	
	public interface EventToFeedEntryConverter{
		 EntryType createFeedEntry(MonitoringEvent e, Kernel kernel);
	}
	
}
