/*********************************************************************************
 * Copyright (c) 2007 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

package de.fzj.unicore.cisprovider.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import de.fzj.unicore.cisprovider.MonitorEventListener;
import de.fzj.unicore.cisprovider.MonitoringEvent;
import de.fzj.unicore.cisprovider.Sensor;
import de.fzj.unicore.cisprovider.jmx.SensorJMX;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Kernel;

public abstract class DefaultSensor implements Sensor {

	protected static final Logger logger=LogUtil.getLogger(LogUtil.SERVICES,DefaultSensor.class);
	
	protected final List<MonitorEventListener> listeners=new ArrayList<MonitorEventListener>();
	
	private MonitoringEvent lastEvent;
	
	private int notifications;
	private int updates;
	
	protected final Kernel kernel;
	
	public DefaultSensor(Kernel kernel){
		this.kernel=kernel;
		initJMX();
	}
	
	public abstract String getName();
	
	protected void initJMX(){
		logger.info("Registering JMX bean for "+getName());
		Kernel.addMBean(new SensorJMX(this), "InfoProviderSensor<"+getName()+">");
	}
	
	public void addEventListener(MonitorEventListener listener) {
		listeners.add(listener);
	}

	public MonitoringEvent getLastEvent() {
		return lastEvent;
	}

	public void removeEventListener(MonitorEventListener listener) {
		listeners.remove(listener);
	}

	/**
	 * Performs notification of registered listeners.<br/>
	 * Subclasses will have to call this method when the actual events 
	 * should be published.
	 */
	protected void doNotify(){
		for(MonitorEventListener l: listeners){
			l.notify(getLastEvent());			
		}
		notifications++;
	}

	protected void setLastEvent(MonitoringEvent e){
		lastEvent=e;
		updates++;
	}
	
	public int getNumberOfNotificationsSent(){
		return notifications;
	}
	
	public int getNumberOfUpdates(){
		return updates;
	}
	
	public void clearStatistics(){
		updates=0;
		notifications=0;
	}
}
