/*********************************************************************************
 * Copyright (c) 2007 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

package de.fzj.unicore.cisprovider.impl;

import java.util.Calendar;
import java.util.UUID;

import org.apache.xmlbeans.XmlObject;

import de.fzj.unicore.cisprovider.MonitoringEvent;
import de.fzj.unicore.cisprovider.Topics;

public class DefaultMonitoringEvent implements MonitoringEvent {

	private String id;
	private Calendar time;
	private String supersedes;
	private String title;
	private String description;
	private XmlObject details;
	private String topic;
	//an event can contain array of event details
	private XmlObject arrDetails[];
	
	public DefaultMonitoringEvent(){
		this.id=UUID.randomUUID().toString();
		time=Calendar.getInstance();
		topic=Topics.ROOT;
	}
	
	
	public String getTitle() {
		return title;
	}


	public void setTitle(String title) {
		this.title = title;
	}


	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description=description;
	}

	public String getID() {
		return id;
	}

	public Calendar getTime() {
		return time;
	}

	public void setTime(Calendar time) {
		this.time=time;
	}

	public String supersedes() {
		return supersedes;
	}

	public void setSupersedes(String supersedes) {
		this.supersedes=supersedes;
	}

	public XmlObject getDetails() {
		return details;
	}
	
	public void setDetails(XmlObject details) {
		this.details=details;
	}


	public String getTopic() {
		return topic;
	}


	public void setTopic(String topic) {
		this.topic = topic;
	}
	
	/**
	 * Default topic matching: matches if the topic of this event is
	 * a subtopic of the requested topic, is computed by the
	 * String.startsWith() method.<br/>
	 */
	public boolean matchesTopic(String topic) {
		return getTopic()==null || getTopic().startsWith(topic);
	}

	@Override
	public String toString(){
		String d=getDetails()!=null?getDetails().toString():"";
		return getTitle()+"\n"
		     + getDescription()+"\n"
		     + "Time: "+getTime().getTime().toString()+"\n"
		     + d;
	}
	
	@Override
	public boolean equals(Object other){
		if(other==null || !(other instanceof DefaultMonitoringEvent))return false;
		return id.equals(((DefaultMonitoringEvent)other).id);
	}

	public void setDetailsArray(XmlObject[] arrDetails){
		this.arrDetails = arrDetails;
	}
	public XmlObject[] getDetailsArray() {
		// TODO Auto-generated method stub
		return arrDetails;
	}
	
	
}
