/*********************************************************************************
 * Copyright (c) 2007 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

package de.fzj.unicore.cisprovider.impl;

import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.w3.x2005.atom.ContentType;
import org.w3.x2005.atom.EntryType;

import de.fzj.unicore.cisprovider.MonitoringEvent;
import de.fzj.unicore.wsrflite.Kernel;

public class DefaultEventConverter implements FeedGenerator.EventToFeedEntryConverter{
	
	public EntryType createFeedEntry(MonitoringEvent e, Kernel kernel){
		 
		 EntryType entry=EntryType.Factory.newInstance();
		 XmlString s=XmlString.Factory.newInstance();
		 s.setStringValue(e.getDescription());
		 entry.addNewSummary().set(s);
		 entry.addNewPublished().setCalendarValue(e.getTime());
		 entry.addNewId().setStringValue(kernel.getContainerProperties().getBaseUrl()
				 +"/CIP/"+e.getID());
		 entry.addNewCategory().setTerm(e.getTopic());
		 entry.addNewAuthor().addName("UNICORE 6 CIP");
		 XmlString t=XmlString.Factory.newInstance();
		 t.setStringValue(e.getTitle());
		 entry.addNewTitle().set(t);
		 
		 
		 if(e.getDetails()!=null){
			 ContentType cType = entry.addNewContent();
			 XmlObject div=XmlObject.Factory.newInstance();
			 XmlCursor c=div.newCursor();
			 c.toNextToken();
			 c.beginElement("div", "http://www.w3.org/1999/xhtml");
			 XmlCursor source=e.getDetails().newCursor();
			 source.toFirstContentToken();
			 source.copyXml(c);
			 cType.set(div);
			 cType.setType("xhtml");
			 c.dispose();
			 source.dispose();
		 }
		 
		 
		 
		 return entry;
	 }

}
