package de.fzj.unicore.cisprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.codehaus.xfire.service.Service;
import org.ogf.schemas.glue.x2009.x03.spec20R1.EndpointHealthStateT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.EndpointT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.QualityLevelT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ServiceT;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xfire.XFireKernel;

public class ServiceInfoGenerator {
	
	public static List<ServiceT> getServiceInformation(Kernel kernel) {
		Collection<Service> col = XFireKernel.get(kernel).getServices();
		List<ServiceT> lstService = new ArrayList<ServiceT>();
		for (Service s : col) {
			String serviceName = s.getSimpleName();
			String id = "urn:unicore:" + serviceName;
			ServiceT sT = ServiceT.Factory.newInstance();
			sT.setID(id);
			sT.setName(serviceName);
			sT.setQualityLevel(QualityLevelT.PRODUCTION);
			EndpointT eprT = sT.addNewEndpoint();
			eprT.setID("urn:unicore:se:"+serviceName);
			String url = WSServerUtilities.makeAddress(serviceName, kernel.getContainerProperties());
			eprT.setURL(url);
			eprT.setHealthState(EndpointHealthStateT.OK);
			eprT.setName(serviceName);
			eprT.addNewWSDL().setStringValue(url+"?wsdl");			
			lstService.add(sT);
		}
		
		return lstService;
	}
	
	
}
