/*********************************************************************************
 * Copyright (c) 2007 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

package de.fzj.unicore.cisprovider;

import java.util.Calendar;

import org.apache.xmlbeans.XmlObject;

/**
 * a monitoring event
 */
public interface MonitoringEvent {
	
	/**
	 * get the time the event occured
	 * @return the time of the event
	 */
	public Calendar getTime();
	
	/**
	 * return a short description of the event
	 * 
	 * @return description
	 */
	public String getTitle();
	
	/**
	 * return a longer human readable description of the event
	 * 
	 * @return description
	 */
	public String getDescription();
	
	/**
	 * Returns the unique ID of the event
	 * 
	 * @return the unique ID
	 */
	public String getID();
	
	/**
	 * if this event obsoletes an older event, 
	 * return the id of the obsolete event,
	 * otherwise return null
	 * 
	 * @return the unique ID of the obsolete event, or null if no such event exists
	 */
	public String supersedes();
	
	/**
	 * An event can contain arbitrary XML content.
	 * 
	 * @return details of the event
	 */
	public XmlObject getDetails();
	
	/**
	 * An event can contain array of an arbitrary XML content.
	 * 
	 * @return details of the event
	 */
	public XmlObject[] getDetailsArray();
	
	/**
	 * get the topic with which this event is associated
	 * 
	 * @return topic (see {@link Topics} for part of a topic list)
	 */
	public String getTopic();
	
	/**
	 * returns <code>true</true> if this event matches the given topic
	 */
	public boolean matchesTopic(String topic);

}
