/*********************************************************************************
 * Copyright (c) 2007 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

package de.fzj.unicore.cisprovider;

import java.util.Calendar;
import java.util.List;

/**
 * Monitor encapsulates the aggregation of information from within the UNICORE container, 
 * and provides this info to any interested party, e.g. a web service, JMX console, etc.<br/>
 * 
 * Monitor aggregates MonitoringEvents from various {@link Sensor}s, which can be registered.<br/>
 * 
 * @author schuller
 */
public interface Monitor {

	/**
	 * register a sensor under the given topic
	 * 
	 * @param sensor - the sensor to register
	 * @param topic - the topic of events the sensor produces
	 */
	public void addSensor(Sensor sensor);
	
	/**
	 * remove a sensor
	 * 
	 * @param sensor
	 */
	public void removeSensor(Sensor sensor);
	
	/**
	 * Query the monitor for events
	 * 
	 * @param topic - the topic of events 
	 * @param from - the start date
	 * @param to - the end date
	 * @param limit - the limit on the number of results
	 * @return a list of monitoring events
	 */
	public List<MonitoringEvent> getEvents(String topic, Calendar from, Calendar to, int limit);
	
}
