/*
 * Copyright (c) 2000-2005, Intel Corporation All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Intel Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package com.intel.gpe.gridbeans.destroy;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import com.intel.gpe.clients.api.Job;
import com.intel.gpe.clients.api.workflow.Action;
import com.intel.gpe.clients.api.workflow.ActionScope;
import com.intel.gpe.clients.api.workflow.Assignment;
import com.intel.gpe.clients.api.workflow.Declaration;
import com.intel.gpe.clients.api.workflow.Destroy;
import com.intel.gpe.clients.api.workflow.GPEWorkflowJob;
import com.intel.gpe.clients.api.workflow.Sequence;
import com.intel.gpe.clients.api.workflow.Variable;
import com.intel.gpe.clients.api.workflow.Workflow;
import com.intel.gpe.gridbeans.AbstractGridBean;
import com.intel.gpe.gridbeans.GridBeanException;
import com.intel.gpe.gridbeans.GridBeanParameter;
import com.intel.gpe.gridbeans.GridBeanParameterType;
import com.intel.gpe.gridbeans.IGridBean;
import com.intel.gpe.gridbeans.workflow.IVariableContainer;
import com.intel.gpe.gridbeans.workflow.WorkflowXMLObject;
import com.intel.util.xml.Namespaces;

/**
 * @author Alexander Lukichev
 * @version $Id: DestroyGridBean.java,v 1.7 2006/10/30 16:13:48 vashorin Exp $
 */
public class DestroyGridBean extends AbstractGridBean implements IGridBean {
    
    public final static QName RESOURCE_ENDPOINT_REFERENCE 
        = new QName("http://gpe.intel.com/gridbeans/destroy", "Resource", "destroy");
    
    public DestroyGridBean() {
        set(RESOURCE_ENDPOINT_REFERENCE, null);
    }
    
    public List<GridBeanParameter> getInputParameters() {
        ArrayList<GridBeanParameter> result= new ArrayList<GridBeanParameter>();
        result.add(new GridBeanParameter(RESOURCE_ENDPOINT_REFERENCE, GridBeanParameterType.XML));
        return result;
    }

    public List<GridBeanParameter> getOutputParameters() {
        ArrayList<GridBeanParameter> result= new ArrayList<GridBeanParameter>();
        result.add(new GridBeanParameter(STATUS, GridBeanParameterType.XML));
        return result;
    }

    public void setupJobDefinition(Job job) throws GridBeanException {
        if (job instanceof GPEWorkflowJob) {
            GPEWorkflowJob wjob = (GPEWorkflowJob) job;
            // specify JSDL
            try {
                Variable epr = null;
                if (get(RESOURCE_ENDPOINT_REFERENCE) != null) {
                    epr = ((IVariableContainer<WorkflowXMLObject>) get(RESOURCE_ENDPOINT_REFERENCE)).getWorkflowVariable().getVariable();
                }
                
                Variable status = null;
                if (get(STATUS) != null) {
                    status = ((IVariableContainer<WorkflowXMLObject>) get(STATUS)).getWorkflowVariable().getVariable();
                }

                
                Namespaces namespaces = new Namespaces();                
                Workflow workflow = wjob.newWorkflow(namespaces);
                Sequence sequence = new Sequence();
                
                Declaration resourcePL = new Declaration(wjob.newPartnerLinkValue());                
                sequence.addAction(resourcePL);
                
                Declaration statusVariable = new Declaration(wjob.newStatusValue("UNDEFINED"));
                wjob.setStatusVariable(statusVariable.getVariable());
                sequence.addAction(statusVariable);

                Declaration failedStatus = new Declaration(wjob.newStatusValue("FAILED"));
                sequence.addAction(failedStatus);
                
                Declaration successfulStatus = new Declaration(wjob.newStatusValue("SUCCESSFUL"));
                sequence.addAction(successfulStatus);
                
                Destroy destroy = wjob.newDestroy(resourcePL.getPartnerLink(), namespaces);
                
                Action setFailed = new Assignment(failedStatus.getVariable(), statusVariable.getVariable());                
                Action setSuccessful = new Assignment(successfulStatus.getVariable(), statusVariable.getVariable());
                
                ActionScope.GenericCatch catchError = new ActionScope.Catch(null, setFailed);
                Sequence tryblock = new Sequence();
                tryblock.addAction(destroy);
                tryblock.addAction(setSuccessful);
                ActionScope scope = new ActionScope(tryblock, new ActionScope.GenericCatch[] { catchError });
                
                if (status != null) {
                    sequence.addAction(new Assignment(statusVariable.getVariable(),status));
                }
                sequence.addAction(new Assignment(epr, resourcePL.getPartnerLink()));
                sequence.addAction(scope);
                wjob.setProcess(workflow, sequence);
            } catch (Exception e) {
                throw new GridBeanException("Cannot setup job definition", e);
            }
        } else {
            throw new GridBeanException("Unsupported job class: "+job.getClass().getName());
        }
    }

    public void parseJobDefinition(Job job) {
        // do nothing
    }

    public String getName() {
        return "DestroyGridBean";
    }

}