/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.InstallDeployTaskSupport;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.tools.ant.BuildException;

public class DeployTask
extends InstallDeployTaskSupport {
    private RemoteRepository remoteRepository;
    private RemoteRepository remoteSnapshotRepository;
    private boolean uniqueVersion = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArtifactRepository createDeploymentArtifactRepository(RemoteRepository repository) {
        ArtifactRepository artifactRepository;
        if (repository.getId().equals(repository.getUrl())) {
            repository.setId("remote");
        }
        this.updateRepositoryWithSettings(repository);
        ArtifactRepositoryLayout repositoryLayout = (ArtifactRepositoryLayout)this.lookup(ArtifactRepositoryLayout.ROLE, repository.getLayout());
        ArtifactRepositoryFactory repositoryFactory = null;
        try {
            repositoryFactory = this.getArtifactRepositoryFactory(repository);
            artifactRepository = repositoryFactory.createDeploymentArtifactRepository(repository.getId(), repository.getUrl(), repositoryLayout, this.uniqueVersion);
        }
        finally {
            this.releaseArtifactRepositoryFactory(repositoryFactory);
        }
        return artifactRepository;
    }

    protected void doExecute() {
        if (this.file == null && this.attachedArtifacts.size() == 0) {
            throw new BuildException("You must specify a file and/or an attached artifact to deploy to the repository.");
        }
        ArtifactRepository localRepo = this.createLocalArtifactRepository();
        Pom pom = this.initializePom(localRepo);
        if (pom == null) {
            throw new BuildException("A POM element is required to deploy to the repository");
        }
        Artifact artifact = pom.getArtifact();
        boolean isPomArtifact = "pom".equals(pom.getPackaging());
        if (!isPomArtifact) {
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pom.getFile());
            artifact.addMetadata(metadata);
        }
        ArtifactRepository deploymentRepository = this.getDeploymentRepository(pom, artifact);
        this.log("Deploying to " + deploymentRepository.getUrl(), 2);
        ArtifactDeployer deployer = (ArtifactDeployer)this.lookup(ArtifactDeployer.ROLE);
        try {
            if (this.file != null) {
                if (!isPomArtifact) {
                    deployer.deploy(this.file, artifact, deploymentRepository, localRepo);
                } else {
                    deployer.deploy(pom.getFile(), artifact, deploymentRepository, localRepo);
                }
            }
            if (this.attachedArtifacts != null) {
                Iterator iter = pom.getAttachedArtifacts().iterator();
                while (iter.hasNext()) {
                    Artifact attachedArtifact = (Artifact)iter.next();
                    deployer.deploy(attachedArtifact.getFile(), attachedArtifact, deploymentRepository, localRepo);
                }
            }
        }
        catch (ArtifactDeploymentException e) {
            throw new BuildException("Error deploying artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    private ArtifactRepository getDeploymentRepository(Pom pom, Artifact artifact) {
        ArtifactRepository deploymentRepository;
        DistributionManagement distributionManagement = pom.getDistributionManagement();
        if (this.remoteSnapshotRepository == null && this.remoteRepository == null && distributionManagement != null) {
            if (distributionManagement.getSnapshotRepository() != null) {
                this.remoteSnapshotRepository = this.createAntRemoteRepositoryBase(distributionManagement.getSnapshotRepository());
                this.uniqueVersion = distributionManagement.getSnapshotRepository().isUniqueVersion();
            }
            if (distributionManagement.getRepository() != null) {
                this.remoteRepository = this.createAntRemoteRepositoryBase(distributionManagement.getRepository());
            }
        }
        if (this.remoteSnapshotRepository == null) {
            this.remoteSnapshotRepository = this.remoteRepository;
        }
        if (artifact.isSnapshot() && this.remoteSnapshotRepository != null) {
            deploymentRepository = this.createDeploymentArtifactRepository(this.remoteSnapshotRepository);
        } else if (this.remoteRepository != null) {
            deploymentRepository = this.createDeploymentArtifactRepository(this.remoteRepository);
        } else {
            throw new BuildException("A distributionManagement element or remoteRepository element is required to deploy");
        }
        return deploymentRepository;
    }

    public RemoteRepository getRemoteRepository() {
        return this.remoteRepository;
    }

    public void addRemoteSnapshotRepository(RemoteRepository remoteSnapshotRepository) {
        this.remoteSnapshotRepository = remoteSnapshotRepository;
    }

    public void addRemoteRepository(RemoteRepository remoteRepository) {
        this.remoteRepository = remoteRepository;
    }

    public void setUniqueVersion(boolean uniqueVersion) {
        this.uniqueVersion = uniqueVersion;
    }

    public boolean getUniqueVersion() {
        return this.uniqueVersion;
    }
}

