/*********************************************************************************
 * Copyright (c) 2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.unicore6;

import java.util.Calendar;

import junit.framework.Assert;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.junit.Test;

import eu.unicore.bugsreporter.annotation.FunctionalTest;
import eu.unicore.bugsreporter.annotation.RegressionTest;
import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.grid.Job;
import eu.unicore.hila.grid.Site;
import eu.unicore.hila.job.jsdl.ModelToJsdl;
import eu.unicore.hila.job.model.JobModel;

/**
 * @author bjoernh
 * 
 *         16.03.2011 15:36:19
 * 
 */
public class Unicore6JobTest extends AbstractUnicore6Test {

    /**
     * Test method for
     * {@link eu.unicore.hila.grid.unicore6.Unicore6Job#getSubmissionTime()}.
     * 
     * @throws HiLAException
     * @throws HiLALocationSyntaxException
     */
    @Test
    @FunctionalTest(description = "Test getSubmissionTime method on Job.", id = "3216067")
    public void testGetSubmissionTime() throws HiLALocationSyntaxException,
	    HiLAException {
	Site site = (Site) new Location(siteLoc).locate();

	JobModel jd = getDateJobDescription();

	Job job = site.submit(jd);
	Calendar submissionTime = Calendar.getInstance();

	// time returned by the server and the locally recorded one should
	// differ less than 1000ms
	Assert.assertEquals(submissionTime.getTime().getTime(), job
		.getSubmissionTime().getTime().getTime(), 1000L);
    }

    @Test
    @RegressionTest(date = "2011-03-16", description = "Wrong job name.", id = 3216648, url = "https://sourceforge.net/tracker/?func=detail&aid=3216648&group_id=102081&atid=633905")
    public void testGetJobName() throws HiLALocationSyntaxException,
	    HiLAException {
	Site site = (Site) new Location(siteLoc).locate();

	JobModel jm = getDateJobDescription();

	Job job = site.submit(jm);

	ModelToJsdl mapping = new ModelToJsdl(jm);

	JobDefinitionDocument jdd = mapping.getJSDL();

	Assert.assertEquals(jdd.getJobDefinition().getJobDescription()
		.getJobIdentification().getJobName(), job.getTaskName());
	Assert.assertFalse(
		"Job name was set and should be different from job id.", job
			.getId().equals(job.getTaskName()));

	jdd.getJobDefinition().getJobDescription().getJobIdentification()
		.setNil();
	job = ((Unicore6Site) site).submit(jdd);
	Assert.assertEquals(
		"Job name has not been set and thus should be equal to the id.",
		job.getId(), job.getTaskName());
    }
}
