/*********************************************************************************
 * Copyright (c) 2010-2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.unicore6.security;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;

import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.grid.Config;
import eu.unicore.hila.grid.ID;
import eu.unicore.hila.grid.unicore6.Unicore6Properties;
import eu.unicore.hila.grid.unicore6.Unicore6SecurityProperties;
import eu.unicore.samly2.exceptions.SAMLParseException;
import eu.unicore.security.etd.TrustDelegation;

/**
 * @author bjoernh
 * 
 *         22.07.2010 13:55:18
 * 
 */
public class TDConfig implements Config {
    private static final Logger log = Logger.getLogger(TDConfig.class);

    private final Unicore6Properties props;
    private final File samlRepo;

    /**
     * 
     */
    public TDConfig(Unicore6Properties _props) {
	this.props = _props;

	samlRepo = new File(
		new File(System.getProperty("user.home"), ".hila2"),
		"saml-assertions");
	samlRepo.mkdirs();
    }

    /**
     * @throws HiLANotImplementedException
     * @see eu.unicore.hila.grid.Config#getAllSiteLocations()
     */
    @Override
    public List<Location> getAllSiteLocations()
	    throws HiLANotImplementedException {
	throw new HiLANotImplementedException(
		"getAllSiteLocations not implemented");
    }

    /**
     * @throws HiLAException
     * @see eu.unicore.hila.grid.Config#getIdForLocation(eu.unicore.hila.Location)
     */
    @Override
    public ID getIdForLocation(Location location) throws HiLAException {
	return determineSecurityProperties(location);
    }

    /**
     * @see eu.unicore.hila.grid.Config#setIdForLocation(eu.unicore.hila.Location,
     *      eu.unicore.hila.grid.ID)
     */
    @Override
    public void setIdForLocation(Location location, ID id) {
	// TODO Auto-generated method stub

    }

    /**
     * @param props
     * @param location
     * @return
     * @throws HiLAException
     */
    private Unicore6SecurityProperties determineSecurityProperties(
	    Location location) throws HiLAException {

	// String profile = new URI(location.toString()).getUserInfo();
	String profile = location.getUser();
	Unicore6SecurityProperties u6secProp = new Unicore6SecurityProperties(
		this.props);

	File samlFile = new File(samlRepo, profile);
	if (samlFile.exists()) {
	    if (log.isDebugEnabled()) {
		log.debug("Reading SAML assertion from " + samlFile);
	    }
	    try {
		AssertionDocument ad = AssertionDocument.Factory
			.parse(samlFile);
		TrustDelegation td = new TrustDelegation(ad);

		List<TrustDelegation> tdList = u6secProp.getETDSettings()
			.getTrustDelegationTokens();
		if (tdList == null) {
		    tdList = new ArrayList<TrustDelegation>();
		}
		tdList.add(td);

		u6secProp.getETDSettings().setTrustDelegationTokens(tdList);
		if (log.isDebugEnabled()) {
		    log.debug("Set trust delegation on securityProperties.");
		}
	    } catch (XmlException e) {
		throw new HiLAException("Invalid SAML assertion for profile "
			+ profile, e);
	    } catch (IOException e) {
		throw new HiLAException(
			"Unable to read SAML assertion for profile " + profile,
			e);
	    } catch (SAMLParseException e) {
		throw new HiLAException("SAML parsing failed for profile "
			+ profile, e);
	    }
	} else {
	    throw new HiLAException("No SAML assertion for profile " + profile);
	}
	// FIXME: Workaround
	u6secProp.toString();
	return u6secProp;
    }
}
