/*********************************************************************************
 * Copyright (c) 2009-2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.unicore6;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;

import eu.unicore.hila.grid.ID;
import eu.unicore.security.canl.CredentialProperties;
import eu.unicore.security.canl.TruststoreProperties;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.PropertyMD;
import eu.unicore.util.configuration.PropertyMD.DocumentationCategory;
import eu.unicore.util.httpclient.ClientProperties;

/**
 * This class wraps the underlying security class {@link ClientProperties}. As
 * of HiLA 2.4.0, CANL security properties must be set inside the client
 * configuration file.
 * 
 * @author bjoernh
 * 
 *         13.08.2009 16:17:43
 * 
 */
public class Unicore6SecurityProperties extends ClientProperties implements ID {
    private static final Logger log = Logger
	    .getLogger(Unicore6SecurityProperties.class);

    @DocumentationReferencePrefix
    public static final String HILA_UNICORE6_BASE = "hila.unicore6";

    @DocumentationReferenceMeta
    public static final Map<String, PropertyMD> DEFAULTS = new HashMap<String, PropertyMD>();
    static {
	DocumentationCategory main = new DocumentationCategory("Main", "a");

	// DEFAULTS.put(key, value)
    }

    private static final String HILAUNICORE6_PROFILE_BASE = HILA_UNICORE6_BASE
	    + ".profile";

    private Unicore6Properties properties;

    private String profile;

    private String profileBase;

    /**
     * @param profile
     * 
     */
    public Unicore6SecurityProperties(Unicore6Properties _props, String _profile) {
	super(_props, HILA_UNICORE6_BASE + "."
		+ (_profile == null ? "" : (_profile + "."))
		+ TruststoreProperties.DEFAULT_PREFIX, HILA_UNICORE6_BASE + "."
		+ (_profile == null ? "" : (_profile + "."))
		+ CredentialProperties.DEFAULT_PREFIX, HILA_UNICORE6_BASE + "."
		+ (_profile == null ? "" : (_profile + "."))
		+ ClientProperties.DEFAULT_PREFIX);
	this.properties = _props;
	this.profile = _profile;

	// does not work anymore as of uas-client 1.4.2
	// getETDSettings().setExtendTrustDelegation(true);

	if (log.isDebugEnabled()) {
	    log.debug("profile == " + profile);
	}

	if (profile == null) {
	    if (log.isDebugEnabled()) {
		log.debug("Using default profile");
	    }
	    this.profileBase = HILA_UNICORE6_BASE;
	} else {
	    this.profileBase = HILAUNICORE6_PROFILE_BASE + "." + profile;
	    if (log.isDebugEnabled()) {
		log.debug("Using profile base " + profileBase);
	    }
	}
    }

    public Unicore6SecurityProperties(Unicore6Properties _props) {
	this(_props, null);
    }

    /**
     * @see ClientProperties#clone()
     */
    @Override
    public Unicore6SecurityProperties clone() {
	try {
	    Unicore6SecurityProperties u6prop = (Unicore6SecurityProperties) super
		    .clone();
	    if (this.profile != null) {
		u6prop.profile = new String(this.profile);
	    } else {
		u6prop.profile = null;
	    }
	    u6prop.properties = (Unicore6Properties) this.properties.clone();
	    if (this.profileBase != null) {
		u6prop.profileBase = new String(this.profileBase);
	    } else {
		u6prop.profileBase = null;
	    }
	    return u6prop;
	} catch (ClassCastException e) {
	    log.error("ClassCastException in clone(): this indicates an unconventional implementation of clone() in a superclass of "
		    + getClass().getName());

	} catch (Exception e) {
	    log.error("Exception in clone()", e);
	}
	return this;
    }

}
