/*********************************************************************************
 * Copyright (c) 2009-2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.unicore6;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

import eu.unicore.hila.grid.unicore6.security.SimpleProfileConfig;

/**
 * @author bjoernh
 * 
 *         13.08.2009 16:03:34
 * 
 */
public class Unicore6Properties extends Properties {
    /**
     * 
     */
    private static final long serialVersionUID = 6618486199881495472L;
    /**
     * 
     */
    public static final String HILA_UNICORE6_CONFIG = "hila.unicore6.config";
    private static final String HILA_UNICORE6_TSS_SEPARATION = "hila.unicore6.separatetss";
    public static final String SITE_UPDATE_INTERVAL = "hila.unicore6.refresh";
    private File configBase = null;

    public List<String> getRegistryUrls() {
	final List<String> urls = new ArrayList<String>();

	StringTokenizer tok = new StringTokenizer(
		getProperty("hila.unicore6.registries"));
	while (tok.hasMoreTokens()) {
	    String url = tok.nextToken();
	    urls.add(url);
	}

	return urls;
    }

    public String getConfigImplementation() {
	return getProperty(HILA_UNICORE6_CONFIG,
		SimpleProfileConfig.class.getName());
    }

    /**
     * @return the configBase
     */
    public File getConfigBase() {
	return configBase;
    }

    /**
     * 
     * @param _configBase
     */
    public void setConfigBase(File _configBase) {
	this.configBase = _configBase;
    }

    /**
     * @see java.util.Hashtable#equals(java.lang.Object)
     */
    @Override
    public synchronized boolean equals(Object _other) {
	if (!(_other instanceof Unicore6Properties)) {
	    return false;
	}

	Unicore6Properties u6prop = (Unicore6Properties) _other;
	if (this.configBase != null) {
	    if (u6prop.configBase != null) {
		return super.equals(_other)
			&& (this.configBase.equals(u6prop.configBase));
	    } else {
		return false;
	    }
	} else {
	    if (u6prop.configBase != null) {
		return false;
	    } else {
		return super.equals(_other);
	    }
	}
    }

    /**
     * @see java.util.Hashtable#hashCode()
     */
    @Override
    public synchronized int hashCode() {
	if (this.configBase != null) {
	    return 1326887 * this.configBase.hashCode() + super.hashCode();
	} else {
	    return super.hashCode();
	}
    }

    /**
     * @return
     */
    public boolean getSeparateTSSs() {
	return Boolean.parseBoolean(getProperty(HILA_UNICORE6_TSS_SEPARATION,
		"false"));
    }
    
    /**
     * @see java.util.Hashtable#clone()
     */
    @Override
    public synchronized Object clone() {
	Unicore6Properties u6p = (Unicore6Properties) super.clone();
	u6p.configBase = this.configBase;
	return u6p;
    }
}
