/*********************************************************************************
 * Copyright (c) 2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.unicore6;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.apache.log4j.Logger;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.BaseResource;
import eu.unicore.hila.exceptions.HiLAException;

/**
 * @author bjoernh
 * 
 *         13.01.2011 08:25:56
 * 
 */
@ResourceType(locationStructure = { "unicore6:/orchestrators/?",
	"unicore6:/{user}@orchestrators/?" })
public class Unicore6OrchestratorsCollection extends BaseResource {
    private static final Logger log = Logger.getLogger(Unicore6OrchestratorsCollection.class);

    private static HashMap<Location, Unicore6OrchestratorsCollection> orchestratorsCollections = new HashMap<Location, Unicore6OrchestratorsCollection>();

    private List<Resource> orchestrators;
    private long orchestratorsTimestamp = 0;

    /**
     * @param _location
     */
    private Unicore6OrchestratorsCollection(Location _location) {
	super(_location);

	orchestrators = new ArrayList<Resource>();
    }

    public static Unicore6OrchestratorsCollection locate(Location _location,
	    Object... _extraInformation) {
	if (orchestratorsCollections.containsKey(_location)) {
	    return orchestratorsCollections.get(_location);
	}
	Unicore6OrchestratorsCollection orchestratorsCollection = new Unicore6OrchestratorsCollection(
		_location);
	orchestratorsCollections.put(_location, orchestratorsCollection);
	return orchestratorsCollection;
    }

    /**
     * @see eu.unicore.hila.Resource#getChildren()
     */
    @Override
    public List<Resource> getChildren() throws HiLAException {
	final Unicore6Grid parent = (Unicore6Grid) getParent();
	final Unicore6Properties props = parent.getProperties();

	List<String> registryUrls = props.getRegistryUrls();

	if (orchestrators.isEmpty()
		|| (System.currentTimeMillis() - orchestratorsTimestamp) > 60000) {
	    if (log.isDebugEnabled()) {
		log.debug("Updating orchestrators list.");
	    }
	    orchestrators.clear();
	    orchestrators.addAll(ServiceOrchestratorLocator.getInstance()
		    .getAllOrchestrators(registryUrls, props, 5000L, location));

	    orchestratorsTimestamp = System.currentTimeMillis();
	}

	return orchestrators;
    }
}
