/*********************************************************************************
 * Copyright (c) 2010 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.unicore6;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.StorageClient;
import eu.unicore.hila.HiLA;
import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.common.grid.BaseSimpleTransfer;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.TaskStatus;
import eu.unicore.hila.grid.unicore6.util.FileTransfers;

/**
 * @author bjoernh
 * 
 *         08.09.2010 09:19:51
 * 
 */
public class Unicore6ImportFromStreamTask extends BaseSimpleTransfer implements
	SimpleTransfer, Callable<TaskStatus> {

    private final Future<TaskStatus> transferFuture;
    private final StorageClient storageClient;
    private final String path;
    private final InputStream is;

    /**
     * @param _location
     * @param unicore6File
     * @throws HiLAException
     */
    public Unicore6ImportFromStreamTask(Location _location,
	    StorageClient _storageClient, String _path, InputStream _is)
	    throws HiLAException {
	super(_location.getChildLocation("imports").getChildLocation(
		UUID.randomUUID().toString()));
	setCurrentState(TaskStatus.NEW);

	this.storageClient = _storageClient;
	this.path = _path;
	this.is = _is;

      this.transferFuture = HiLA.getExecutor().submit(this);
    }

    /**
     * @see eu.unicore.hila.grid.Task#abort()
     */
    @Override
    public void abort() throws HiLAException {
	this.transferFuture.cancel(true);
	setCurrentState(TaskStatus.ABORTED);
    }

    /**
     * @see eu.unicore.hila.grid.Task#getId()
     */
    @Override
    public String getId() throws HiLAException {
	return getName();
    }

    /**
     * @see eu.unicore.hila.Resource#getChildren()
     */
    @Override
    public List<Resource> getChildren() throws HiLAException {
	List<Resource> children = new ArrayList<Resource>();
	return children;
    }

    /**
     * @see java.util.concurrent.Callable#call()
     */
    @Override
    public TaskStatus call() throws Exception {
	setCurrentState(TaskStatus.RUNNING);

	try {
         Map<String, String> extraParameters = new HashMap<String, String>();
         FileTransfers.getDefaultUftpParameters(extraParameters);
         FileTransferClient ftc = storageClient.getImport(this.path, false,
               extraParameters, FileTransfers.getFTPrefs());

	    ftc.writeAllData(this.is);
	    setCurrentState(TaskStatus.SUCCESSFUL);
	} catch (IOException e) {
	    HiLAException e2 = new HiLAException("Unable to import file.", e);
	    setCurrentState(TaskStatus.FAILED, e2);
	    throw e2;
	} catch (Exception e) {
	    HiLAException e2 = new HiLAException("Unable to import file.", e);
	    setCurrentState(TaskStatus.FAILED, e2);
	    throw e2;
	}

	return status();
    }

}
