/*********************************************************************************
 * Copyright (c) 2010-2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.unicore6;

import java.util.List;

import org.apache.log4j.Logger;

import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.wsrflite.xfire.ClientException;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceNotDestroyedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.SimpleTransfer;

/**
 * @author bjoernh
 * 
 *         25.05.2010 15:04:43
 * 
 */
public class CleanupAction implements Runnable {

    private static final Logger log = Logger.getLogger(CleanupAction.class);

    private final List<SimpleTransfer> transfers;
    private final JobClient jobClient;

   private Unicore6Job job;

    /**
    * @param _transfers
    * @param unicore6Job
    */
   public CleanupAction(List<SimpleTransfer> _transfers, Unicore6Job _job) {
	this.transfers = _transfers;
      this.job = _job;
      this.jobClient = _job.jobClient;
    }

    /**
     * @see java.lang.Runnable#run()
     */
    @Override
    public void run() {
	for (SimpleTransfer transfer : transfers) {
	    try {
		transfer.block();
	    } catch (HiLAException e) {
		log.error("Error while blocking on task export", e);
	    }
	}

	try {
	    if (log.isDebugEnabled()) {
		log.debug("Destroying WS Resource "
			+ jobClient.getEPR().getAddress().getStringValue());
	    }
	    jobClient.destroy();
         Unicore6Job.removeFromCache(job);
	} catch (BaseFault e) {
	    log.error("Unable to destroy job.", e);
	} catch (ResourceUnavailableFault e) {
	    log.error("Unable to destroy job.", e);
	} catch (ResourceUnknownFault e) {
	    log.error("Unable to destroy job.", e);
	} catch (ResourceNotDestroyedFault e) {
	    log.error("Unable to destroy job.", e);
	} catch (ClientException e) {
	    log.error("Unable to destroy job.", e);
	}
    }

}
