/*********************************************************************************
 * Copyright (c) 2010 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.shell.completors;

import java.util.List;

import jline.Completor;

import org.apache.log4j.Logger;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.shell.ShellContext;

/**
 * @author bjoernh
 * 
 *         26.04.2010 13:26:51
 * 
 */
public class LocationCompletor implements Completor {

    private static final Logger log = Logger.getLogger(LocationCompletor.class);
    private ShellContext shellContext;

    /**
     * 
     */
    public LocationCompletor(ShellContext _context) {
	this.shellContext = _context;
    }

    /**
     * @see jline.Completor#complete(java.lang.String, int, java.util.List)
     */
    @Override
    public int complete(String buffer, int cursor, List candidates) {

	if (buffer == null) {
	    try {
		Resource res = shellContext.getCurrentLocation().locate();
		List<Resource> children = res.getChildren();
		for (Resource resource : children) {
		    candidates.add(resource.getName());
		}
		return cursor;
	    } catch (HiLAException e) {
	    }
	    return 0;
	}

	String partLocString = buffer.substring(
		buffer.lastIndexOf(' ', cursor) + 1, cursor);
	//String partLocString = buffer.substring(0, cursor);
	if (log.isDebugEnabled()) {
	    log.debug("partLocString: " + partLocString);
	}

	Location partLoc;
	try {
	    partLoc = new Location(partLocString);
	} catch (HiLALocationSyntaxException e1) {
	    return 0;
	}

	if (partLocString.endsWith("/") || partLocString.isEmpty()) {
	    try {
		Resource res = partLoc.locate();
            List<Resource> children = res.getChildren();
            for (Resource resource : children) {
               candidates.add(resource.getName());
            }
            return cursor;
	    } catch (HiLAException e) {
            // this can safely be ignored, try to continue with absolute location
            }
            

	} else {

	    if (!partLoc.isAbsolute()) {
		try {
		    partLoc = shellContext.getCurrentLocation().getChildLocation(
		    	partLocString);
		} catch (HiLALocationSyntaxException e) {
		    return 0;
		}
	    }

	    Location parentLoc = partLoc.getParentLocation();

	    if (log.isDebugEnabled()) {
		log.debug("partLoc  : " + partLoc);
		log.debug("parentLoc: " + parentLoc);
	    }
	    String partName = partLoc.getName();
	    try {
		Resource res = parentLoc.locate();
		if (res == null) {
		    if (log.isDebugEnabled()) {
			log.debug("Trying absolute location: "
				+ shellContext.getCurrentLocation()
					.getChildLocation(partLocString));
		    }
		    res = shellContext.getCurrentLocation().getChildLocation(
			    partLocString).locate();
		}
		if (res != null) {
		    List<Resource> children = res.getChildren();
		    for (Resource resource : children) {
			if (resource.getName().startsWith(partName)) {
			    candidates.add(resource.getName());
			}
		    }
		    return cursor - partName.length();
		}
	    } catch (HiLAException e) {
		log.warn("Resource not locatable.", e);
	    }
	}

	return 0;
    }

}
