/*********************************************************************************
 * Copyright (c) 2009 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.shell.commands;

import java.io.IOException;
import java.util.Collection;

import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;

import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.shell.ShellContext;

/**
 * @author bjoernh
 * 
 *         22.10.2009 13:10:47
 * 
 */
public abstract class ShellCommandBase implements ShellCommand {

    private static final Logger log = Logger.getLogger(ShellCommandBase.class);

    protected Options options = new Options();
    protected CommandLineParser parser = new PosixParser();

    /**
     * @see eu.unicore.hila.shell.commands.ShellCommand#getName()
     */
    public String getName() {
	return getClass().getSimpleName().toLowerCase();
    }

    /**
     * @see eu.unicore.hila.shell.commands.ShellCommand#help()
     */
    public String help() {
	final StringBuilder sb = new StringBuilder();
	for (Option option : (Collection<Option>) options.getOptions()) {
	    final StringBuilder lineBuilder = new StringBuilder();
	    lineBuilder.append("-".concat(option.getOpt()));
	    if (option.getLongOpt() != null) {
		lineBuilder.append(", ");
		lineBuilder.append("--".concat(option.getLongOpt()));
	    }
	    lineBuilder
		    .append("                                                  ");
	    lineBuilder.insert(20, option.getDescription());
	    lineBuilder.append(System.getProperty("line.separator"));
	    sb.append(lineBuilder);
	}

	return sb.toString();
    }

    /**
     * @param string
     */
    protected void missingArg(String string) {

    }

    /**
     * @param ctx
     * 
     */
    protected void printHelp(ShellContext ctx) {
	String helpString = help();
	try {
	    ctx.getCs().printString(helpString);
	    ctx.getCs().printNewline();
	} catch (IOException e) {
	    log.info(helpString);
	}

    }

    /**
     * @throws HiLANotImplementedException
     * @throws HiLAException
     * @see eu.unicore.hila.shell.commands.ShellCommand#execute(java.lang.String[],
     *      eu.unicore.hila.shell.ShellContext)
     */
    @Override
    public void execute(String[] cmdArgs, ShellContext ctx)
	    throws HiLAException {
	throw new HiLANotImplementedException("Command not implemented.");
    }

    /**
     * @see eu.unicore.hila.shell.commands.ShellCommand#getOptions()
     */
    @Override
    public Options getOptions() {
	return options;
    }

}
