/*********************************************************************************
 * Copyright (c) 2010 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.shell.commands;

import java.util.List;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.shell.ShellContext;

/**
 * @author bjoernh
 * 
 *         16.03.2010 10:59:20
 * 
 */
public class ChMod extends ShellCommandBase implements ShellCommand {
    private static final Logger log = Logger.getLogger(ChMod.class);

    /**
     * 
     */
    public ChMod() {
	super();
	initializeOptions();
    }

    /**
     * 
     */
    private void initializeOptions() {
	options.addOption(OptionBuilder.withArgName("h").withDescription(
		"This help message.").withLongOpt("help").create("h"));
	options.addOption(OptionBuilder.withArgName("r").hasArg(true)
		.withDescription("Set read permission to true/false")
		.withLongOpt("read").create("r"));
	options.addOption(OptionBuilder.withArgName("w").hasArg(true)
		.withDescription("Set write permission to true/false")
		.withLongOpt("write").create("w"));
	options.addOption(OptionBuilder.withArgName("x").hasArg(true)
		.withDescription("Set executable permission to true/false")
		.withLongOpt("execute").create("x"));
    }

    /**
     * @see eu.unicore.hila.shell.commands.ShellCommand#execute(java.lang.String[],
     *      eu.unicore.hila.shell.ShellContext)
     */
    @Override
    public void execute(String[] cmdArgs, ShellContext ctx)
	    throws HiLAException {
	try {
	    boolean setReadable = false;
	    boolean readable = false;
	    boolean setWritable = false;
	    boolean writable = false;
	    boolean setExecutable = false;
	    boolean executable = false;

	    CommandLine cmdline = parser.parse(options, cmdArgs);

	    if (cmdline.hasOption("h")) {
		printHelp(ctx);
		return;
	    }

	    if (cmdline.hasOption("r")) {
		setReadable = true;
		readable = Boolean.parseBoolean(cmdline.getOptionValue("r"));
	    }
	    if (cmdline.hasOption("w")) {
		setWritable = true;
		writable = Boolean.parseBoolean(cmdline.getOptionValue("w"));
	    }
	    if (cmdline.hasOption("x")) {
		setExecutable = true;
		executable = Boolean.parseBoolean(cmdline.getOptionValue("x"));
	    }

	    List<String> opts = cmdline.getArgList();
	    opts.remove(0);
	    if (opts.size() > 0) {
		for (String string : opts) {
		    try {
			Location loc = new Location(string);
			if (!loc.isLocationOfType(File.class)) {
			    loc = ctx.getCurrentLocation().getChildLocation(
				    string);
			}
			if (loc.isLocationOfType(File.class)) {
			    File file = (File) loc.locate();
			    if (setReadable) {
				file.setIsReadable(readable);
			    }
			    if (setWritable) {
				file.setIsWritable(writable);
			    }
			    if (setExecutable) {
				file.setIsExecutable(executable);
			    }
			} else {
			    log
				    .error("Cannot set permissions on non-file resource");
			}
		    } catch (HiLAException e) {
			log.error("Setting permissions for " + string
				+ " failed", e);
		    }
		}
	    }

	} catch (ParseException e) {

	}
    }

}
