/*********************************************************************************
 * Copyright (c) 2009 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.shell.commands;

import java.io.IOException;

import org.apache.log4j.Logger;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.shell.ShellContext;

/**
 * @author bjoernh
 * 
 *         16.10.2009 14:45:39
 * 
 */
public class Cd extends ShellCommandBase implements ShellCommand {

    private static final Logger log = Logger.getLogger(Cd.class);

    /**
     * @throws HiLALocationSyntaxException
     * @see eu.unicore.hila.shell.commands.ShellCommand#execute(java.lang.String[],
     *      eu.unicore.hila.shell.ShellContext)
     */
    public void execute(String[] cmdArgs, ShellContext ctx)
	    throws HiLALocationSyntaxException {
	if (cmdArgs.length == 1) {
	    try {
		ctx.getCs().printString("No home location defined.");
	    } catch (IOException e) {
		log
			.error(
				"jLine couldn't print message. Message was:" +
				" \"No home location defined.\"",
				e);
	    }
	} else if (cmdArgs.length == 2) {
	    final Location absLoc = new Location(cmdArgs[1]);
         try {
            Resource res = absLoc.locate();
            if (res instanceof File) {
               File file = (File) res;
               if (!file.exists()) {
                  log.warn("Cannot cd into a non-existing directory.");
                  return;
               } else if (!file.isDirectory()) {
                  log.warn("Cannot cd into ordinary files.");
                  return;
               }
            }
            ctx.setCurrentLocation(absLoc);
            return;
         } catch (HiLAException e) {
            if (log.isDebugEnabled()) {
               log.debug("Cannot locate location " + absLoc);
            }
         }
	    if (ctx.getCurrentLocation() != null) {
		Location relLoc = null;
		if (cmdArgs[1].equals("..")) {
		    relLoc = ctx.getCurrentLocation().getParentLocation();
		} else {
		    relLoc = ctx.getCurrentLocation().getChildLocation(
			    cmdArgs[1]);
		}
		try {
		    Resource res = relLoc.locate();
		    if (res != null) {
			if (res instanceof File) {
			    File file = (File) res;
			    if (!file.exists()) {
				log
					.warn("Cannot cd into a non-existing directory.");
				return;
			    } else if (!file.isDirectory()) {
				log.warn("Cannot cd into ordinary files.");
				return;
			    }
			}
			ctx.setCurrentLocation(relLoc);
			return;
		    }
		} catch (HiLAException e) {
		    log.error("Something is wrong with the given resource.", e);
		}
	    }
	    log.warn("Couldn't set new location as absolute or relative"
		    + " location. Current location still is "
		    + ctx.getCurrentLocation());
	} else {
	    log.error("Can only cd to a single location.");
	}
    }

}
