/*********************************************************************************
 * Copyright (c) 2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.shell.commands;

import java.util.List;
import java.util.Map;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.shell.ShellContext;

/**
 * @author bjoernh
 * 
 *         03.08.2011 16:11:55
 * 
 */
public class Alias extends ShellCommandBase {

    private static final Logger log = Logger.getLogger(Alias.class);

    /**
     * @see eu.unicore.hila.shell.commands.ShellCommandBase#execute(java.lang.String[],
     *      eu.unicore.hila.shell.ShellContext)
     */
    @Override
    public void execute(String[] cmdArgs, ShellContext ctx)
	    throws HiLAException {
	Map<String, String> aliases = ctx.getAliases();

	try {
	    final CommandLine cmdLine = parser.parse(options, cmdArgs);
	    List<String> argList = cmdLine.getArgList();
	    argList.remove(0); // remove the command itself
	    if (argList.size() > 2) {
		log.error("Don't know what to do with an argument list of size > 2.");
		return;
	    } else if (argList.size() == 2) {
		if (argList.get(0).endsWith("=")) {
		    aliases.put(
			    argList.get(0).substring(0,
				    argList.get(0).length() - 1),
			    argList.get(1));
		}
	    } else if (argList.size() == 1) {
		printAlias(aliases, argList.get(0));
	    } else if (argList.size() == 0) {
		for (String string : aliases.keySet()) {
		    printAlias(aliases, string);
		}
	    }

	} catch (ParseException e) {
	    log.error("Unable to parse command.", e);
	}

    }

    /**
     * @param aliases
     * @param string
     */
    private void printAlias(Map<String, String> aliases, String string) {
	if(aliases.containsKey(string)) {
	System.out
		.println("alias " + string + "='" + aliases.get(string) + "'");
	} else {
	    System.out.println("alias " + string + ": not found");
	}
    }
}
