/*********************************************************************************
 * Copyright (c) 2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.job.model;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

import eu.unicore.hila.job.spi.MappingFactorySpi;
import eu.unicore.hila.job.spi.NoSuchMappingException;

/**
 * @author bjoernh
 *
 * 21.12.2011 15:53:30
 *
 */
public class MappingFactory {
   // public static ModelToNative getModelToNativeMapping(String _native) {
   //
   // }
   //
   // public static NativeToModel getNativeToModelMapping(String _native) {
   //
   // }

   public static List<String> getMappings() {
      List<String> formats = new ArrayList<String>();
      ServiceLoader<MappingFactorySpi> mappings = ServiceLoader
            .load(MappingFactorySpi.class);
      for (MappingFactorySpi mappingFactory : mappings) {
         formats.add(mappingFactory.getFormatName());
      }

      return formats;
   }

   /**
    * @param string
    * @return
    * @throws NoSuchMappingException
    */
   public static MappingFactorySpi getMapping(String string)
         throws NoSuchMappingException {
      ServiceLoader<MappingFactorySpi> mappings = ServiceLoader
            .load(MappingFactorySpi.class);
      for (MappingFactorySpi mappingFactory : mappings) {
         if (mappingFactory.getFormatName().equals(string)) {
            return mappingFactory;
         }
      }
      throw new NoSuchMappingException("Mapping for " + string
            + " could not be found.");
   }

}
