/*********************************************************************************
 * Copyright (c) 2012 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.emi.es;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import eu.unicore.emi.es.clients.ActivityInfoClient;
import eu.unicore.emi.es.clients.ActivityManagementClient;
import eu.unicore.emi.es.clients.CreateActivityClient;
import eu.unicore.hila.grid.Config;

/**
 * @author bjoernh
 * 
 *         13.01.2012 09:07:38
 * 
 */
public class EmiEsProperties extends Properties {

   /**
    * 
    */
   private static final long serialVersionUID = 1760098679687339488L;

   private static final String EMI_ES_PROP_BASE = "hila.emi.es";

   private static final String EMI_ES_ENDPOINT_BASE = EMI_ES_PROP_BASE
         + ".endpoint.base";

   private static final String EMI_ES_KEYSTORE = EMI_ES_PROP_BASE + ".keystore";

   private static final String EMI_ES_KEYSTORE_FILE = EMI_ES_KEYSTORE + ".file";

   private static final String EMI_ES_KEYSTORE_ALIAS = EMI_ES_KEYSTORE
         + ".alias";

   private static final String EMI_ES_KEYSTORE_PASSWORD = EMI_ES_KEYSTORE
         + ".password";

   private static final String EMI_ES_KEYSTORE_TYPE = EMI_ES_KEYSTORE + ".type";

	private static final String EMI_ES_SVC_CREATION = EMI_ES_PROP_BASE
			+ ".creationName";

	private static final String EMI_ES_SVC_AI = EMI_ES_PROP_BASE + ".infoName";

	private static final String EMI_ES_SVC_AMGMT = EMI_ES_PROP_BASE
			+ ".mgmtName";

	private static final String EMI_EMIR_ENDPOINT = EMI_ES_PROP_BASE + ".emir";

   private File configBase = null;

   /**
    * @return the configBase
    */
   public File getConfigBase() {
      return configBase;
   }

   /**
    * 
    * @param _configBase
    */
   public void setConfigBase(File _configBase) {
      this.configBase = _configBase;
   }

   public List<String> getSiteEndpoints() {
      List<String> siteEndpoints = new ArrayList<String>();

      for (Object key : keySet()) {
         if (key instanceof String) {
            String string = (String) key;
            if (string.contains(EMI_ES_ENDPOINT_BASE)) {
               siteEndpoints.add(getProperty((String) key));
            }
         }
      }

      return siteEndpoints;
   }

	/**
 * 
 */
	public List<String> getEmirEndpoints() {
		List<String> emirEndpoints = new ArrayList<String>();

		for (Object key : keySet()) {
			String string = (String) key;
			if (string.contains(EMI_EMIR_ENDPOINT)) {
				emirEndpoints.add(getProperty((String) key));
			}
		}

		return emirEndpoints;
	}

   /**
    * @see java.util.Hashtable#equals(java.lang.Object)
    */
   @Override
   public synchronized boolean equals(Object _other) {
      if (!(_other instanceof EmiEsProperties)) {
         return false;
      }

      EmiEsProperties emiProps = (EmiEsProperties) _other;
      if (this.configBase != null) {
         if (emiProps.configBase != null) {
            return super.equals(_other)
                  && (this.configBase.equals(emiProps.configBase));
         } else {
            return false;
         }
      } else {
         if (emiProps.configBase != null) {
            return false;
         } else {
            return super.equals(_other);
         }
      }
   }

   /**
    * @see java.util.Hashtable#hashCode()
    */
   @Override
   public synchronized int hashCode() {
      if (this.configBase != null) {
         return 1326887 * this.configBase.hashCode() + super.hashCode();
      } else {
         return super.hashCode();
      }
   }

   /**
    * @see java.util.Hashtable#clone()
    */
   @Override
   public synchronized Object clone() {
      EmiEsProperties emiProps = (EmiEsProperties) super.clone();
      emiProps.configBase = this.configBase;
      return emiProps;
   }

   /**
    * @return
    */
   public Config getConfig() {
      return new EmiEsConfig(this);
   }

	/**
	 * @return
	 */
	public String getCreationServiceName() {
		return getProperty(EMI_ES_SVC_CREATION,
				CreateActivityClient.SERVICE_NAME);
	}

	public String getActivityInfoServiceName() {
		return getProperty(EMI_ES_SVC_AI, ActivityInfoClient.SERVICE_NAME);
	}

	public String getActivityManagementServiceName() {
		return getProperty(EMI_ES_SVC_AMGMT,
				ActivityManagementClient.SERVICE_NAME);
	}

    /**
     * @return
     */
    public String getEmirEndpoint() {
        return getProperty(EMI_EMIR_ENDPOINT);
    }

}
