package eu.unicore.hila.grid.bes;

import java.io.File;
import java.util.Collections;
import java.util.List;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration.Enum;

import de.fzj.unicore.bes.client.ActivityClient;
import de.fzj.unicore.wsrflite.xfire.ClientException;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceNotDestroyedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.grid.BaseJob;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLAFactoryException;
import eu.unicore.hila.exceptions.HiLANotSupportedException;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.TaskStatus;

@ResourceType(locationStructure = {
		BesImplementationProvider.SCHEME + ":/sites/{siteName}/jobs/{jobId}/?",
		BesImplementationProvider.SCHEME
				+ ":/{user}@sites/{siteName}/jobs/{jobId}/?" })
public class BesJob extends BaseJob {

	private static final Cache tasksCache;
	static {
		CacheManager cm = CacheManager.getInstance();
		cm.addCache(new Cache(BesJob.class.getName(), 500, true, true, 0, 0));
		tasksCache = cm.getCache(BesJob.class.getName());
	}

	private ActivityClient activityClient = null;

	/**
	 * @param _location
	 * @param _extraInformation
	 * @throws HiLAFactoryException
	 */
	private BesJob(Location _location, Object[] _extraInformation)
			throws HiLAFactoryException {
		super(_location);
		for (Object object : _extraInformation) {

			if (object instanceof ActivityClient) {
				activityClient = (ActivityClient) object;
			}
		}
		if (activityClient == null) {
			throw new HiLAFactoryException("Unable to locate task: "
					+ _location.toString());
		}
		tasksCache.put(new Element(_location, this));
	}

	public static final synchronized Resource locate(Location _location,
			Object... _extraInformation) throws HiLAException {
		if (tasksCache.isKeyInCache(_location)) {
			Element cachedTask = tasksCache.get(_location);
			if (cachedTask != null) {
				return (BesJob) cachedTask.getObjectValue();
			}
		}

		if (_extraInformation.length > 0) {
			return new BesJob(_location, _extraInformation);
		}

		return ((BesSite) findParentLocationOfType(BesSite.class, _location,
				BesGrid.class).locate()).getTask(_location.getName());
	}

	/**
	 * @see eu.unicore.hila.grid.Task#abort()
	 */
	@Override
	public void abort() throws HiLAException {
		try {
			activityClient.abort();
		} catch (Exception e) {
			throw new HiLAException("Abort failed", e);
		}
	}

	/**
	 * @see eu.unicore.hila.grid.Task#getId()
	 */
	@Override
	public String getId() throws HiLAException {
		return this.getLocation().getName();
	}

	/**
	 * @see eu.unicore.hila.common.grid.BaseTask#status()
	 */
	@Override
	public TaskStatus status() throws HiLAException {
      if (isFinalState(super.status())) {
         return super.status();
      } else {
         return mapStatus();
      }
	}

	/**
	 * @return
	 * @throws HiLAException
	 */
	private TaskStatus mapStatus() throws HiLAException {
		try {
			Enum aStatus = activityClient.getStatus();
			switch (aStatus.intValue()) {
			case ActivityStateEnumeration.INT_FAILED:
				return TaskStatus.FAILED;
			case ActivityStateEnumeration.INT_CANCELLED:
				return TaskStatus.ABORTED;
			case ActivityStateEnumeration.INT_FINISHED:
				return TaskStatus.SUCCESSFUL;
			case ActivityStateEnumeration.INT_PENDING:
				return TaskStatus.PENDING;
			case ActivityStateEnumeration.INT_RUNNING:
				return TaskStatus.RUNNING;
			default:
				throw new HiLAException("Unable to determine status.");
			}
		} catch (Exception e) {
			throw new HiLAException("Unable to retrieve activity status.", e);
		}
	}

	/**
	 * @see eu.unicore.hila.grid.Job#startASync(java.io.File[])
	 */
	@Override
	public void startASync(File... imports) throws HiLAException {
		if (imports.length > 0) {
			throw new HiLANotSupportedException(
					"OGSA-BES Cannot accept files for client stage in. Activity has already started.");
		}
	}

	/**
	 * @see eu.unicore.hila.grid.Job#cleanup(eu.unicore.hila.grid.File[])
	 */
	@Override
	public List<SimpleTransfer> cleanup(eu.unicore.hila.grid.File... exports)
			throws HiLAException {
		try {
			activityClient.destroy();
		} catch (BaseFault e) {
			throw new HiLAException("Unable to destroy job.", e);
		} catch (ResourceUnavailableFault e) {
			throw new HiLAException("Unable to destroy job.", e);
		} catch (ResourceUnknownFault e) {
			throw new HiLAException("Unable to destroy job.", e);
		} catch (ResourceNotDestroyedFault e) {
			throw new HiLAException("Unable to destroy job.", e);
		} catch (ClientException e) {
			throw new HiLAException("Unable to destroy job.", e);
		}

		return Collections.EMPTY_LIST;
	}

	/**
	 * @see eu.unicore.hila.grid.Job#getExitCode()
	 */
	@Override
	public int getExitCode() throws HiLAException {
		try {
			return activityClient.getExitCode();
		} catch (Exception e) {
			throw new HiLAException("Unable to retrieve exit code.", e);
		}
	}

	/**
	 * @see eu.unicore.hila.grid.Job#getLog()
	 */
	@Override
	public String getLog() throws HiLAException {
		throw new HiLANotSupportedException(
				"OGSA-BES does not allow to retrieve log.");
	}

	/**
	 * @see eu.unicore.hila.grid.Job#getStdErr()
	 */
	@Override
	public eu.unicore.hila.grid.File getStdErr() throws HiLAException {
		throw new HiLANotSupportedException(
				"OGSA-BES does not allow to retrieve stderr.");
	}

	/**
	 * @see eu.unicore.hila.grid.Job#getStdOut()
	 */
	@Override
	public eu.unicore.hila.grid.File getStdOut() throws HiLAException {
		throw new HiLANotSupportedException(
				"OGSA-BES does not allow to retrieve stdout.");
	}

	/**
	 * @see eu.unicore.hila.grid.Job#getWorkingDirectory()
	 */
	@Override
	public eu.unicore.hila.grid.File getWorkingDirectory() throws HiLAException {
		throw new HiLANotSupportedException(
				"OGSA-BES does not allow access to working directory.");
	}

}
