/*********************************************************************************
 * Copyright (c) 2009 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila;

import java.util.List;

import eu.unicore.hila.exceptions.HiLAException;

/**
 * A {@link Resource} is the most generic form of a resource in HiLA.
 * {@link Resource}s can have child {@link Resource}s and at most one parent
 * {@link Resource}.
 * 
 * @author bjoernh
 * 
 */
public interface Resource {
	public Location getLocation();

	public List<Resource> getChildren() throws HiLAException;

	public Resource getChild(String childPath) throws HiLAException;

	public Resource getParent() throws HiLAException;

	public Metadata getMetadata() throws HiLAException;

	/**
	 * The last element of the URI, either the last name before a final "/" or
	 * the last name after the "/", i.e.
	 * <ul>
	 * <li>hila-impl:/sites/site/storages/home</li>
	 * <li>hila-impl:/sites/site/storages/home/</li>
	 * </ul>
	 * would both return "home" as the name.
	 * 
	 * @return name of the {@link Resource}.
	 */
	public String getName();

	/**
	 * Test whether a resource is ok, i.e. accessible.
	 * 
	 * @return true, if the ressource is accessible, false otherwise
	 */
	public boolean ok();

}
