/*********************************************************************************
 * Copyright (c) 2009 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.log4j.Logger;

/**
 * 
 * @author bjoernh
 * 
 */
public class LocationPattern {

	private static final Logger log = Logger.getLogger(LocationPattern.class);

	private Pattern pattern = null;
	private List<String> variables = null;

	/**
	 * @param templateString
	 */
	public LocationPattern(String templateString) {
		this.pattern = makePattern(templateString);
		log.debug(this.pattern);
	}

	/**
	 * 
	 * @param location
	 * @return
	 */
	public boolean match(Location location) {
		CharSequence cs = location.getStringValue();
		final Matcher m1 = this.pattern.matcher(cs);
		return m1.matches();
		/*
		 * if(m1.matches()) { return true; }
		 * 
		 * if(cs.charAt(cs.length()-1) == '/') { cs = cs.subSequence(0,
		 * cs.length()-1); } final Matcher m2 = this.pattern.matcher(cs); return
		 * m2.matches();
		 */
	}

	/**
	 * 
	 * @param location
	 * @return
	 */
	public Map<String, String> fillTemplates(Location location) {
		Map<String, String> templateVariables = new HashMap<String, String>();

		Matcher m = this.pattern.matcher(location.getStringValue());
		if (m.matches()) {
			log.debug("Expression " + m.pattern() + " matches "
					+ location.getStringValue());
			log.debug("" + m.groupCount() + " == " + variables.size() + " : "
					+ (m.groupCount() == variables.size()));
			if (m.groupCount() == variables.size()) {
				int i = 1;
				for (String variable : variables) {
					String value = m.group(i++);
					templateVariables.put(variable, value);
					log.debug("Put variable " + variable + " as " + value);
				}
			}
		}

		return templateVariables;
	}

	/**
	 * @param templateString2
	 * @return
	 */
	private Pattern makePattern(String templateString2) {
		Pattern pat = Pattern.compile("\\{[^{}@/]*\\}");
		Matcher m = pat.matcher(templateString2);
		variables = new ArrayList<String>();
		while (m.find()) {
			variables.add(m.group());
			log.debug("adding variable " + m.group());
		}
		return Pattern.compile(m.replaceAll("([^{}/]+)"));
	}
}
