/*********************************************************************************
 * Copyright (c) 2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.unicore6;

import java.util.List;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.job.model.JobModel;

/**
 * @author bjoernh
 * 
 *         16.03.2011 15:38:16
 * 
 */
@Ignore
public class AbstractUnicore6Test {
    protected static String siteLoc;
    protected static final String DEFAULT_JOB_NAME = "HiLA Test";

    /**
     * @throws java.lang.Exception
     */
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
	UASStarter.getInstance().start();

	Location sitesLoc = new Location("unicore6:/sites");
	List<Resource> sites = null;
	do {
	    if (sitesLoc.locate() != null) {
		sites = sitesLoc.locate().getChildren();
	    } else {
		Assert.fail("setUpBeforeClass failed");
	    }
	} while (sites.isEmpty());

	siteLoc = sites.get(0).getLocation().toString();
    }

    @AfterClass
    public static void tearDown() {
        // UASStarter.getInstance().tearDown();
    }

    /**
     * @return
     */
    protected JobModel getDateJobDescription() {
	final JobModel jm = new JobModel();
	jm.setApplicationName("Date");
	jm.setApplicationVersion("1.0");
	jm.setTaskName(DEFAULT_JOB_NAME);
	return jm;
    }
}
