/*********************************************************************************
 * Copyright (c) 2012 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.unicore6.util;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

import org.apache.log4j.Logger;
import org.unigrids.services.atomic.types.ProtocolType;

import de.fzj.unicore.uas.client.UFTPConstants;

/**
 * @author bjoernh
 * 
 *         09.02.2012 14:09:10
 * 
 */
public class FileTransfers {

   /**
    * 
    */
   private static final String KEY_TRANSFERPREFS = "transferprefs";

   private static final Logger log = Logger
         .getLogger(FileTransfers.class);

   /**
    * @param extraParameters
    */
   public static void getDefaultUftpParameters(
         final Map<String, String> extraParameters) {
      // check hostname
      String host = extraParameters.get(UFTPConstants.PARAM_CLIENT_HOST);
      if (host == null) {
         try {
            host = InetAddress.getLocalHost().getCanonicalHostName();
            extraParameters.put(UFTPConstants.PARAM_CLIENT_HOST, host);
         } catch (Exception e) {
            log.error("Unable to determine local hostname for UFTP transfer.");
         }
      }
      String streams = extraParameters.get(UFTPConstants.PARAM_STREAMS);
      if (streams == null) {
         extraParameters.put(UFTPConstants.PARAM_STREAMS, "2");
      }
   }

   /**
    * @return
    */
   public static ProtocolType.Enum[] getFTPrefs() {
      Collection<ProtocolType.Enum> transferPrefs = new ArrayList<ProtocolType.Enum>();

      Preferences prefs = Preferences.userNodeForPackage(FileTransfers.class);
      try {
         prefs.sync();
      } catch (BackingStoreException e1) {
         log.warn("Unable to read preferences.", e1);
      }

      String rawPrefs = prefs.get(KEY_TRANSFERPREFS, "BFT RBYTEIO");
      // ensure they're written to storage
      prefs.put(KEY_TRANSFERPREFS, rawPrefs);
      try {
         prefs.flush();
      } catch (BackingStoreException e) {
         log.warn("Unable to persist preferences.", e);
      }
      StringTokenizer tok = new StringTokenizer(rawPrefs);
      while (tok.hasMoreTokens()) {
         String curTok = tok.nextToken();
         final ProtocolType.Enum type = ProtocolType.Enum.forString(curTok);
         if (type != null) {
            transferPrefs.add(type);
         }
      }

      return transferPrefs.toArray(new ProtocolType.Enum[transferPrefs.size()]);
   }

}
