/*********************************************************************************
 * Copyright (c) 2010 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.unicore6;

import java.util.concurrent.Callable;

import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.client.StorageClient;

import eu.unicore.hila.Location;
import eu.unicore.hila.grid.Storage;

/**
 * @author bjoernh
 * 
 *         27.05.2010 17:59:04
 * 
 */
public class GetStorageFromEPR implements Callable<Storage> {

    private final EndpointReferenceType sEPR;
    private final Unicore6SecurityProperties secProp;
    private final Location parentLocation;

    /**
     * @param _sEPR
     * @param _unicore6SecurityProperties
     * @param _parentLocation
     */
    public GetStorageFromEPR(EndpointReferenceType _sEPR,
	    Unicore6SecurityProperties _unicore6SecurityProperties,
	    Location _parentLocation) {
	this.sEPR = _sEPR;
	this.secProp = _unicore6SecurityProperties;
	this.parentLocation = _parentLocation;
    }

    /**
     * @see java.util.concurrent.Callable#call()
     */
    @Override
    public Storage call() throws Exception {

	StorageClient client = new StorageClient(sEPR, secProp);
	final String storageName = client.getStorageName();

	final Location loc = parentLocation.getChildLocation(storageName);

	Storage storage = Unicore6Storage.locate(loc, client);

	return storage;
    }

}
