/*********************************************************************************
 * Copyright (c) 2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.unicore6;

import java.net.URL;
import java.util.concurrent.Callable;

import org.apache.log4j.Logger;
import org.chemomentum.common.ws.IServiceOrchestrator;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import eu.unicore.hila.Location;
import eu.unicore.hila.grid.Submittable;
import eu.unicore.util.httpclient.IClientConfiguration;

/**
 * @author bjoernh
 * 
 *         12.01.2011 10:56:57
 * 
 */
public class GetOrchestratorFromEPR implements Callable<Submittable> {

    private static final Logger log = Logger
	    .getLogger(GetOrchestratorFromEPR.class);

    private EndpointReferenceType oEPR;
    private Location parentLocation;
    private IClientConfiguration secProps;

    /**
     * @param _oEPR
     * @param _secProps
     * @param _parentLocation
     */
    public GetOrchestratorFromEPR(EndpointReferenceType _oEPR,
            IClientConfiguration _secProps, Location _parentLocation) {
	this.oEPR = _oEPR;
	this.secProps = _secProps;
	this.parentLocation = _parentLocation;
    }

    /**
     * @see java.util.concurrent.Callable#call()
     */
    @Override
    public Submittable call() throws Exception {
	BaseWSRFClient orchClient = new BaseWSRFClient(oEPR.getAddress()
		.getStringValue(), oEPR, secProps);
	IServiceOrchestrator orchestrator = orchClient
		.makeProxy(IServiceOrchestrator.class);

	String orchName = (new URL(oEPR.getAddress().getStringValue()))
		.getPath().split("/")[1];

	if (log.isTraceEnabled()) {
	    log.trace("Orchestrator name: " + orchName);
	}

	final Location loc = parentLocation.getChildLocation(orchName);

	Unicore6Orchestrator u6orchestrator = (Unicore6Orchestrator) loc
		.locate(orchestrator, secProps);

	return u6orchestrator;
    }
}
