/*********************************************************************************
 * Copyright (c) 2010 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.shell.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Job;
import eu.unicore.hila.grid.Task;
import eu.unicore.hila.shell.ShellContext;

/**
 * @author bjoernh
 * 
 *         18.05.2010 16:41:03
 * 
 */
public class Status extends ShellCommandBase implements ShellCommand {

    private static final Logger log = Logger.getLogger(Status.class);

    /**
     * 
     */
    public Status() {
	initializeOptions();
    }

    /**
     * 
     */
    private void initializeOptions() {
	options.addOption(OptionConstants.HELP);
	options.addOption(OptionConstants.LOG);
    }

    /**
     * @see eu.unicore.hila.shell.commands.ShellCommandBase#execute(java.lang.String[],
     *      eu.unicore.hila.shell.ShellContext)
     */
    @Override
    public void execute(String[] cmdArgs, ShellContext ctx)
	    throws HiLAException {
	try {
	    CommandLine cmdLine = parser.parse(options, cmdArgs);

	    if (cmdLine.hasOption(OptionConstants.HELP.getArgName())) {
		printHelp(ctx);
		return;
	    }

	    final List<String> argList = cmdLine.getArgList();
	    argList.remove(0); // removing the command
	    final List<Location> taskLocations = new ArrayList<Location>();
	    for (String taskLocStr : argList) {
		Location taskLoc = new Location(taskLocStr);
		if (!taskLoc.isAbsolute()) {
		    taskLoc = ctx.getCurrentLocation().getChildLocation(
			    taskLocStr);
		}
		if (!taskLoc.isLocationOfType(Task.class)) {
		    log.warn("Location " + taskLocStr + " is not of type "
			    + Task.class.getName());
		} else {
		    taskLocations.add(taskLoc);
		}
	    }

	    for (Location location : taskLocations) {
		if (log.isDebugEnabled()) {
		    log.debug("locating " + location);
		}
		final Task task = (Task) location.locate();
		log.info("##########");
		log.info("Job " + task.getLocation());
		log.info("Status: " + task.status());
		if (cmdLine.hasOption(OptionConstants.LOG.getArgName())) {
		    if (task instanceof Job) {
			Job cmpTask = (Job) task;
			log.info(cmpTask.getLog());
		    } else {
			log.warn("Job log only supported by "
				+ Job.class.getName());
		    }

		}

		HiLAException e = task.getError();
		if (e != null) {
		    StringWriter sw = new StringWriter();
		    PrintWriter pw = new PrintWriter(sw);
		    e.printStackTrace(pw);
		    log.info("Task error reason: " + sw.toString());
		}
	    }

	} catch (ParseException e) {
	    log.error("Command line could not be parsed.", e);
	}
    }
}
