/*********************************************************************************
 * Copyright (c) 2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.shell.commands;

import java.util.List;
import java.util.Set;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

import eu.unicore.hila.Location;
import eu.unicore.hila.Metadata;
import eu.unicore.hila.Resource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.shell.ShellContext;

/**
 * @author bjoernh
 * 
 *         28.06.2011 08:46:43
 * 
 */
public class GetMetadata extends ShellCommandBase {
    private static final Logger log = Logger.getLogger(GetMetadata.class);

    /**
     * 
     */
    public GetMetadata() {
	super();
	initializeOptions();
    }

    /**
     * @see eu.unicore.hila.shell.commands.ShellCommandBase#execute(java.lang.String[],
     *      eu.unicore.hila.shell.ShellContext)
     */
    @Override
    public void execute(String[] cmdArgs, ShellContext ctx)
	    throws HiLAException {
	CommandLine cmdline = null;
	try {
	    cmdline = parser.parse(options, cmdArgs);
	    // print help and return
	    if (cmdline.hasOption(OptionConstants.HELP.getOpt())) {
		printHelp(ctx);
		return;
	    }
	    List<String> arglist = cmdline.getArgList();
	    // remove the command itself
	    arglist.remove(0);
	    for (String sLoc : arglist) {
		try {
		    Location loc = new Location(sLoc);
               Resource res = null;
               try {
						res = loc.locate();
               } catch (HiLAException e) {
                  loc = ctx.getCurrentLocation().getChildLocation(sLoc);
                  res = loc.locate();
               }

		    Metadata md = res.getMetadata();
		    System.out.println(loc + " : ");
		    if (md != null) {
			Set<String> properties = md.getProperties();
			// list available properties on that resource
			if (cmdline.hasOption(OptionConstants.LIST.getOpt())) {
			    for (String property : properties) {
				System.out.println("  " + property);
			    }
			} else if (cmdline.hasOption(OptionConstants.PROPERTY
				.getOpt())) {
			    String propArg = cmdline
				    .getOptionValue(OptionConstants.PROPERTY
					    .getOpt());
			    if (propArg != null) {
				Object property = md.getData(propArg);
				if (property != null) {
				    System.out.println(" " + propArg);
				    System.out.println("  " + property);
				} else {
				    log.warn("Property " + propArg
					    + " does not exist on resource "
					    + loc);
				}
			    }
			} else {
			    for (String property : properties) {
				System.out.println(" " + property);
				System.out.println("  " + md.getData(property));
			    }
			}
		    }
		} catch (HiLAException e) {
		    log.warn(e);
		}
	    }
	    return;
	} catch (ParseException e) {
	    log.error("Unable to parse commandline.", e);
	}
    }

    private void initializeOptions() {
	options.addOption(OptionConstants.HELP);
	options.addOption(OptionConstants.LIST);
	options.addOption(OptionConstants.PROPERTY);
    }
}
