/*********************************************************************************
 * Copyright (c) 2010 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.shell.commands;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.shell.ShellContext;

/**
 * @author bjoernh
 * 
 *         07.09.2010 17:15:40
 * 
 */
public class Cat extends ShellCommandBase implements ShellCommand {
    private static final Logger log = Logger.getLogger(Cat.class);

    /**
     * @see eu.unicore.hila.shell.commands.ShellCommandBase#execute(java.lang.String[],
     *      eu.unicore.hila.shell.ShellContext)
     */
    @Override
    public void execute(String[] cmdArgs, ShellContext ctx)
	    throws HiLAException {
	CommandLine cmdline = null;
	try {
	    cmdline = parser.parse(options, cmdArgs);
	    if (cmdline.hasOption(OptionConstants.HELP.getOpt())) {
		printHelp(ctx);
		return;
	    }
	} catch (ParseException e) {
	    log.error("Unable to parse command line", e);
	    return;
	}

	List<String> args = cmdline.getArgList();
	args.remove(0);
	if (args.size() == 0) {
	    log.error("Nothing to cat");
	    return;
	}

	for (String arg : args) {
	    Location loc = null;
	    try {
		loc = new Location(arg);
		if (!loc.isLocationOfType(File.class)) {
		    loc = ctx.getCurrentLocation().getChildLocation(arg);
		}
		if (loc.isLocationOfType(File.class)) {
		    try {
			SimpleTransfer trsf = ((File) loc.locate())
				.exportToStream(System.out);
			trsf.block();
		    } catch (HiLAException e) {
			log.error("Cating " + loc + " to console failed.", e);
		    }
		}
	    } catch (HiLAException e) {
		log.error("Unable to handle location " + loc, e);
	    }
	}

    }
}
