/*********************************************************************************
 * Copyright (c) 2009 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.shell;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import jline.ConsoleReader;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.shell.commands.ShellCommand;

/**
 * @author bjoernh
 *
 * 16.10.2009 13:42:10
 *
 */
public class ShellContext {
    private Location currentLocation = null;
    private File     currentLocalDir = null;
    private boolean  isDone = false;
    private ConsoleReader cs = null;
    
    /**
     * @return the cs
     */
    public ConsoleReader getCs() {
        return cs;
    }

    /**
     * @param isDone the isDone to set
     */
    public void setDone(boolean isDone) {
        this.isDone = isDone;
    }

    private final Map<String, ShellCommand> commands = new HashMap<String, ShellCommand>();
    private final Map<String, String> aliases;
    
    /**
     * @throws HiLALocationSyntaxException 
     * 
     */
    public ShellContext(ConsoleReader _cs) throws HiLALocationSyntaxException {
	currentLocation = new Location("");
	currentLocalDir = new File("").getAbsoluteFile();
	this.cs = _cs;
	this.aliases = new HashMap<String, String>();
    }

    /**
     * @return the currentLocation
     */
    public Location getCurrentLocation() {
        return this.currentLocation;
    }

    /**
     * @param currentLocation the currentLocation to set
     */
    public void setCurrentLocation(Location currentLocation) {
        this.currentLocation = currentLocation;
    }

    /**
     * @return the currentLocalDir
     */
    public File getCurrentLocalDir() {
        return this.currentLocalDir;
    }

    /**
     * @param currentLocalDir the currentLocalDir to set
     */
    public void setCurrentLocalDir(File currentLocalDir) {
        this.currentLocalDir = currentLocalDir;
    }
    
    public ShellCommand getCommand(String _cmd) {
	return commands.get(_cmd);
    }
    
    public void registerCommand(String _cmdName, ShellCommand _cmd) {
	commands.put(_cmdName, _cmd);
    }
    
    public void registerCommand(ShellCommand _cmd) {
	commands.put(_cmd.getName(), _cmd);
    }

    /**
     * @return
     */
    public boolean isDone() {
	return this.isDone;
    }

    /**
     * @return
     */
    public Collection<String> getCommands() {
	return commands.keySet();
    }

    /**
     * @param string
     * @return
     */
    public boolean isAlias(String string) {
	return aliases.containsKey(string);
    }

    /**
     * @param string
     * @return
     */
    public String getAlias(String string) {
	return aliases.get(string);
    }
    
    /**
     * @return the aliases
     */
    public Map<String, String> getAliases() {
	return aliases;
    }
}
