/*********************************************************************************
 * Copyright (c) 2010 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid;

import eu.unicore.hila.exceptions.HiLAException;

/**
 * The {@link Progressable} interface allows a user to monitor progress, i.e.
 * how far a {@link File} {@link ThirdPartyTransfer} has progressed. This
 * interface exists to generate human-readable information, i.e. "36/42 bytes"
 * transferred.
 * 
 * @author bjoernh
 * 
 *         12.03.2010 15:22:47
 * 
 */
public interface Progressable {
    /**
     * A human-readable {@link String} describing the unit of the progress, e.g.
     * "bytes"
     * 
     * @return A unit {@link String}
     * @throws HiLAException
     */
    String getUnit() throws HiLAException;

    /**
     * @return The maximum value.
     * @throws HiLAException
     */
    long getMax() throws HiLAException;

    /**
     * 
     * @return The current value, i.e. progress.
     * @throws HiLAException
     */
    long getCurrent() throws HiLAException;
    
    /**
     * 
     * @return
     * @throws HiLAException
     */
    boolean isDone() throws HiLAException;
}
