package eu.unicore.hila;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

/**
 * This class is able to return all classes in a given package. It may not work
 * for the default package, which you shouldn't use anyway.
 * 
 */
public class PackageUtil {

	public static Set<Class<?>> getClasses(String packageName) throws Exception {
		ClassLoader loader = Thread.currentThread().getContextClassLoader();
		return getClasses(loader, packageName, true);
	}

	public static Set<Class<?>> getClasses(ClassLoader loader,
			String packageName, boolean includeSubPackages) throws Exception {
		Set<Class<?>> classes = new HashSet<Class<?>>();
		String path = packageName.replace('.', '/');
		Enumeration<URL> resources = loader.getResources(path);
		if (resources != null) {
			while (resources.hasMoreElements()) {
				String filePath = resources.nextElement().getFile();
				// WINDOWS HACK
				if (filePath.indexOf("%20") > 0)
					filePath = filePath.replaceAll("%20", " ");
				if (filePath != null) {
					if ((filePath.indexOf("!") > 0)
							&& (filePath.indexOf(".jar") > 0)) {
						String jarPath = filePath.substring(0,
								filePath.indexOf("!")).substring(
								filePath.indexOf(":") + 1);
						// WINDOWS HACK
						if (jarPath.indexOf(":") >= 0)
							jarPath = jarPath.substring(1);
						classes.addAll(getFromJARFile(loader, jarPath,
								packageName, includeSubPackages));
					} else {
						classes.addAll(getFromDirectory(loader, new File(
								filePath), packageName, includeSubPackages));
					}
				}
			}
		}
		return classes;
	}

	public static Set<Class<?>> getFromDirectory(ClassLoader loader,
			File directory, String packageName, boolean includeSubPackages)
			throws Exception {
		Set<Class<?>> classes = new HashSet<Class<?>>();
		if (directory.exists()) {
			for (File file : directory.listFiles()) {
				if (file.getName().endsWith(".class")) {
					String name = packageName + '.'
							+ stripFilenameExtension(file.getName());
					Class<?> clazz = loader.loadClass(name);
					classes.add(clazz);
				} else if (includeSubPackages && file.isDirectory()) {
					classes.addAll(getFromDirectory(loader, file, packageName
							+ "." + file.getName(), true));
				}
			}
		}
		return classes;
	}

	public static Set<Class<?>> getFromJARFile(ClassLoader loader, String jar,
			String packageName, boolean includeSubPackages) throws Exception {
		String path = packageName.replace('.', '/');
		Set<Class<?>> classes = new HashSet<Class<?>>();
		JarInputStream jarFile = new JarInputStream(new FileInputStream(jar));
		JarEntry jarEntry;
		do {
			jarEntry = jarFile.getNextJarEntry();
			if (jarEntry != null) {
				String className = jarEntry.getName();
				if (className.endsWith(".class")) {
					className = stripFilenameExtension(className);
					if (className.startsWith(path)
							&& (includeSubPackages || className.split("/").length == path
									.split("/").length + 1)) {
						classes.add(loader.loadClass(className
								.replace('/', '.')));
					}
				}
			}
		} while (jarEntry != null);
		jarFile.close();
		return classes;
	}

	public static String stripFilenameExtension(String _className) {
		int idx = _className == null ? -1 : _className.indexOf('.');
		if (idx < 1)
			return _className;

		return _className.substring(0, idx);
	}

}
