/*********************************************************************************
 * Copyright (c) 2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.unicore6;

import java.io.File;

import junit.framework.Assert;

import org.junit.Test;

/**
 * @author bjoernh
 * 
 *         14.02.2011 13:33:28
 * 
 */
public class Unicore6PropertiesTest {

    /**
     * Test method for
     * {@link eu.unicore.hila.grid.unicore6.Unicore6Properties#hashCode()}.
     */
    @Test
    public void testHashCode() {
	Unicore6Properties u6prop1 = new Unicore6Properties();
	final int h1 = u6prop1.hashCode();
	u6prop1.setConfigBase(new File("."));
	final int h2 = u6prop1.hashCode();
	Assert.assertFalse(h1 == h2);
	u6prop1.setProperty("asdf", "jklo");
	final int h3 = u6prop1.hashCode();
	Assert.assertFalse(h1 == h3);
	Assert.assertFalse(h2 == h3);
    }

    /**
     * Test method for
     * {@link eu.unicore.hila.grid.unicore6.Unicore6Properties#getConfigBase()}.
     */
    @Test
    public void testGetConfigBase() {
	Unicore6Properties u6prop = new Unicore6Properties();
	u6prop.setConfigBase(new File("."));
	Assert.assertEquals(new File("."), u6prop.getConfigBase());
    }

    /**
     * Test method for
     * {@link eu.unicore.hila.grid.unicore6.Unicore6Properties#setConfigBase(java.io.File)}
     * .
     */
    @Test
    public void testSetConfigBase() {
	testGetConfigBase(); // same test
    }

    /**
     * Test method for
     * {@link eu.unicore.hila.grid.unicore6.Unicore6Properties#equals(java.lang.Object)}
     * .
     */
    @Test
    public void testEqualsObject() {
	final Unicore6Properties u6props1 = new Unicore6Properties();
	Assert.assertEquals(u6props1, u6props1);
	final Unicore6Properties u6props2 = new Unicore6Properties();
	Assert.assertEquals(u6props1, u6props2);
	u6props2.setProperty("asdf", "jklo");
	Assert.assertFalse(u6props1.equals(u6props2));
	u6props1.setProperty("asdf", "jkl");
	Assert.assertFalse(u6props1.equals(u6props2));
	u6props1.setProperty("asdf", "jklo");
	Assert.assertEquals(u6props1, u6props2);
	u6props1.setConfigBase(new File("."));
	Assert.assertFalse(u6props1.equals(u6props2));
	Assert.assertFalse(u6props2.equals(u6props1));
	Assert.assertEquals(u6props1, u6props1);
    }

}
