/*********************************************************************************
 * Copyright (c) 2010-2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.unicore6;

import java.io.File;

import de.fzj.unicore.uas.UAS;

/**
 * @author bjoernh
 * 
 *         20.07.2010 12:23:31
 * 
 */
public class UASStarter {

    private static UASStarter theInstance = null;

    private UAS uas = null;

    private boolean starting = false;

    public static synchronized UASStarter getInstance() throws Exception {
	System.setProperty(Unicore6Grid.CONFIG_KEY,
		"src/test/resources/unicore6.properties");
	if (theInstance == null) {
	    theInstance = new UASStarter();
	}
	return theInstance;
    }

    /**
     * @throws Exception
     * 
     */
    public UASStarter() throws Exception {
	new File("target", "data").delete();
        uas = new UAS("src/test/resources/uas.config");
    }

    public synchronized void start() throws Exception {
	if (!starting) {
	    starting = true;
	    uas.startSynchronous();
	}
    }

    /**
     * 
     */
    public void tearDown() {
        uas.getKernel().shutdown();

    }

}
