/*********************************************************************************
 * Copyright (c) 2009 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.unicore6;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.BaseResource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Grid;
import eu.unicore.hila.grid.Site;

/**
 * @author bjoernh
 * 
 *         14.08.2009 15:41:48
 * 
 */
@ResourceType(locationStructure = { "unicore6:/sites/{site}/tasks/?",
	"unicore6:/{user}@sites/{site}/tasks/?" })
public class TasksCollection extends BaseResource implements Resource {

    public static final String TASKS = "tasks";

    private static final Map<Location, TasksCollection> tasksCollections = new HashMap<Location, TasksCollection>();

    /**
     * @param location
     */
    private TasksCollection(Location location) {
	super(location);
    }

    public static synchronized Resource locate(Location _location) {
	if (tasksCollections.containsKey(_location)) {
	    return tasksCollections.get(_location);
	} else {
	    final TasksCollection tasksCollection = new TasksCollection(
		    _location);
	    tasksCollections.put(_location, tasksCollection);
	    return tasksCollection;
	}
    }

    /**
     * @see eu.unicore.hila.Resource#getChildren()
     */
    public List<Resource> getChildren() throws HiLAException {
	final List<Resource> tasks = new ArrayList<Resource>();

	Location siteLoc = findParentLocationOfType(Site.class, this.location,
		Grid.class);
	if (siteLoc != null) {
	    Site site = (Site) siteLoc.locate();
	    tasks.addAll(site.getTasks());
	}

	return tasks;
    }

}
