/*********************************************************************************
 * Copyright (c) 2010 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.shell.commands;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;

/**
 * @author bjoernh
 * 
 *         31.03.2010 14:26:01
 * 
 */
public class OptionConstants {

    public static final Option RECURSIVE = OptionBuilder.withArgName("r")
	    .withDescription("recursive operation").withLongOpt("recursive")
	    .create("r");
    public static final Option FORCE = OptionBuilder.withArgName("f")
	    .withDescription("Force overwrite").withLongOpt("force")
	    .create("f");
    public static final Option HELP = OptionBuilder.withArgName("h")
	    .withDescription("Print help message.").withLongOpt("help")
	    .create("h");
    public static final Option BLOCK = OptionBuilder.withArgName("b")
	    .withDescription("Block on task.").withLongOpt("block")
	    .hasArg(false).create("b");
    public static final Option INTERVAL = OptionBuilder.withArgName("interval")
	    .withDescription("Interval between updates.")
	    .withLongOpt("interval").hasArg(true).create("i");
    public static final Option APP_NAME = OptionBuilder.withArgName("an")
	    .withDescription("Application name").withLongOpt("application")
	    .hasArg(true).create("an");
    public static final Option APP_VERSION = OptionBuilder.withArgName("av")
	    .withDescription("Application version").withLongOpt("version")
	    .hasArg(true).create("ver");
    public static final Option APP_EXECUTABLE = OptionBuilder.withArgName("ex")
	    .withDescription("Executable").withLongOpt("exec").hasArg(true)
	    .create("e");
    public static final Option APP_ARGUMENT = OptionBuilder.withArgName("arg")
	    .withDescription("Argument").withLongOpt("arg").hasArg(true)
	    .create("arg");
    public static final Option JSDL = OptionBuilder.withArgName("JSDL")
	    .withLongOpt("jsdl")
	    .withDescription("JSDL document to be submitted.").hasArg(true)
	    .create("j");
    public static final Option SITE = OptionBuilder.withArgName("Site")
	    .withLongOpt("site")
	    .withDescription("Site to which to submit the job.").hasArg(true)
	    .create("s");
    public static final Option LOG = OptionBuilder.withArgName("log")
	    .hasArg(false).withLongOpt("log")
	    .withDescription("Print the job log.").create("l");
    public static final Option EXPORT = OptionBuilder.withArgName("e")
	    .hasArg(true).withLongOpt("export")
	    .withDescription("Export files from working directory.")
	    .create("e");
    public static final Option EXPORT_NONE = OptionBuilder
	    .withArgName("noexport").withLongOpt("no-export")
	    .withDescription("Export no files.").create("n");
    public static final Option EXPORT_ALL = OptionBuilder
	    .withArgName("exportall").withLongOpt("export-all")
	    .withDescription("Export all files.").create("a");
    public static final Option LIST = OptionBuilder.withArgName("list")
	    .withLongOpt("list").withDescription("List available properties.")
	    .create("l");
    public static final Option PROPERTY = OptionBuilder.withArgName("property")
	    .withLongOpt("property").withDescription("Specify a property")
	    .hasArg(true).create("p");

}
