/*********************************************************************************
 * Copyright (c) 2009 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.shell.commands;

import java.util.List;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.shell.ShellContext;

/**
 * @author bjoernh
 * 
 *         16.10.2009 15:54:20
 * 
 */
public class Mv extends ShellCommandBase implements ShellCommand {
    private static final Logger log = Logger.getLogger(Mv.class);

    /**
     * 
     */
    public Mv() {
	initOptions();
    }

    /**
     * 
     */
    private void initOptions() {
	options.addOption(OptionConstants.HELP);
	options.addOption(OptionConstants.FORCE);
    }

    /**
     * @see eu.unicore.hila.shell.commands.ShellCommandBase#execute(java.lang.String[],
     *      eu.unicore.hila.shell.ShellContext)
     */
    @Override
    public void execute(String[] cmdArgs, ShellContext ctx)
	    throws HiLAException {
	CommandLine cmdLine;
	try {
	    cmdLine = parser.parse(options, cmdArgs);
	} catch (ParseException e) {
	    log.error("Unable to parse the command line.", e);
	    return;
	}

	if (cmdLine.hasOption(OptionConstants.HELP.getArgName())) {
	    printHelp(ctx);
	    return;
	}

	List<String> argList = cmdLine.getArgList();
	argList.remove(0); // remove command

	if (argList.size() == 2) {
	    Location srcLoc = new Location(argList.get(0));
	    if (!srcLoc.isLocationOfType(File.class)) {
		srcLoc = ctx.getCurrentLocation().getChildLocation(
			argList.get(0));
	    }
	    if (!srcLoc.isLocationOfType(File.class)) {
		throw new HiLAException("Source is not a file.");
	    }

	    Location dstLoc = new Location(argList.get(1));
	    if (!dstLoc.isLocationOfType(File.class)) {
		dstLoc = ctx.getCurrentLocation().getChildLocation(
			argList.get(1));
	    }
	    if (!dstLoc.isLocationOfType(File.class)) {
		throw new HiLAException("Destination is not a file.");
	    }

	    File src = (File) srcLoc.locate();
	    File dst = (File) dstLoc.locate();

	    src.moveTo(dst, cmdLine.hasOption(OptionConstants.FORCE.getArgName()));
	}

    }

    /**
     * @see eu.unicore.hila.shell.commands.ShellCommandBase#help()
     */
    @Override
    public String help() {
	return "Move a file to a new location. Will only work within a storage."
		+ " Use transfer for remote copy."
		+ System.getProperty("line.separator")
		+ System.getProperty("line.separator") + super.help();
    }

}
