/*********************************************************************************
 * Copyright (c) 2010 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.shell.commands;

import java.util.List;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Progressable;
import eu.unicore.hila.shell.ShellContext;

/**
 * @author bjoernh
 * 
 *         09.04.2010 15:18:36
 * 
 */
public class Monitor extends ShellCommandBase {
    private static final Logger log = Logger.getLogger(Monitor.class);

    /**
     * 
     */
    public Monitor() {
	initializeOptions();
    }

    /**
     * 
     */
    private void initializeOptions() {
	options.addOption(OptionConstants.HELP);
	options.addOption(OptionConstants.INTERVAL);
    }

    /**
     * @see eu.unicore.hila.shell.commands.ShellCommandBase#execute(java.lang.String[],
     *      eu.unicore.hila.shell.ShellContext)
     */
    @Override
    public void execute(String[] cmdArgs, ShellContext ctx)
	    throws HiLAException {
	CommandLine cmdLine;
	try {
	    cmdLine = parser.parse(options, cmdArgs);
	} catch (ParseException e) {
	    throw new HiLAException("Unable to parse command line.", e);
	}
	
	if(cmdLine.hasOption(OptionConstants.HELP.getArgName())) {
	    printHelp(ctx);
	    return;
	}

	List<String> argList = cmdLine.getArgList();
	argList.remove(0); // remove command

	if (argList.size() == 1) { // monitor exactly one Progressable
	    String locStr = argList.get(0);
	    Location loc = new Location(locStr);
	    if (!loc.isLocationOfType(Progressable.class)) {
		loc = ctx.getCurrentLocation().getChildLocation(locStr);
	    }
	    if (!loc.isLocationOfType(Progressable.class)) {
		throw new HiLAException(
			"Location does not point ot a Progressable resource.");
	    }

	    long interval = 1000L; // 1 second intervals for update
	    if (cmdLine.hasOption(OptionConstants.INTERVAL.getArgName())) {
		String intervalString = cmdLine
			.getOptionValue(OptionConstants.INTERVAL.getArgName());
		try {
		    interval = Long.parseLong(intervalString);
		} catch (NumberFormatException e) {
		    log.warn("Cannot parse number from " + intervalString
			    + ". Using default of 1000ms.", e);
		}
	    }

	    Progressable prog = (Progressable) loc.locate();
	    do {
		log.info(Long.toString(prog.getCurrent()) + "/"
			+ Long.toString(prog.getMax()) + " " + prog.getUnit());
		try {
		    Thread.sleep(interval);
		} catch (InterruptedException e) {

		}
	    } while (!prog.isDone());
	} else {
	    throw new HiLAException(
		    "Can only monitor one progresable at a time.");
	}
    }
}
