/*********************************************************************************
 * Copyright (c) 2010 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.job.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import junit.framework.Assert;

import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;
import org.junit.Test;

import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;

/**
 * @author bjoernh
 * 
 *         27.05.2010 15:44:54
 * 
 */
public class JSDLBuilderTest {

    /**
     * Test method for {@link eu.unicore.hila.grid.job.JobModel#getJsdl()}.
     * 
     * @throws HiLAException
     */
//    @Test
//    public void testGetJsdl() throws HiLAException {
//	final JobModel jb = new JobModel();
//
//	jb.setExecutable("/bin/date");
//
//	final ResourcesType resources = ResourcesType.Factory.newInstance();
//	resources.addNewTotalCPUTime().addNewExact().setDoubleValue(1);
//	resources.addNewTotalCPUCount().addNewExact().setDoubleValue(1);
//
//	XmlOptions xo = new XmlOptions().setSavePrettyPrint()
//		.setSavePrettyPrintIndent(3);
//
//	System.out.println(jb.getJsdl().xmlText(xo));
//
//	jb.setResources(resources);
//
//	System.out.println(jb.getJsdl().xmlText(xo));
//    }

    @Test
    public void testAddArbitraryResource() throws HiLAException {
	final JobModel jb = new JobModel();

	jb.setExecutable("/bin/date");

	final ResourcesType resources = ResourcesType.Factory.newInstance();

	XmlObject reservationResource = XmlObject.Factory.newInstance();
	XmlCursor resCurs = reservationResource.newCursor();
	resCurs.toNextToken();

	resCurs.beginElement(new QName("http://www.unicore.eu/reservation",
		"ReservationId"));
	resCurs.insertChars("426c3234-841c-11df-93e6-001f160cb28c");
	resCurs.toStartDoc();
	resCurs.toNextToken();

	XmlCursor resourcesCursor = resources.newCursor();
	resourcesCursor.toNextToken();

	resCurs.moveXml(resourcesCursor);

	System.out.println(resources.xmlText());

	resources.addNewCandidateHosts().addHostName("zam025c01");

	jb.setResources(resources);

    }

    @Test
    public void testGetImports() {
	JobModel jb = new JobModel();
	Assert.assertNotNull(jb.getImports());
	Assert.assertEquals(0, jb.getImports().size());
    }

    @Test
    public void testSetImports() {
	JobModel jb = new JobModel();
	Import imp = new Import(null, null);
	jb.setImports(Collections.singletonList(imp));

	Assert.assertNotNull(jb.getImports());
	Assert.assertEquals(1, jb.getImports().size());
	Assert.assertNull(jb.getImports().get(0).getTargetName());
	Assert.assertNull(jb.getImports().get(0).getSource());
    }

    @Test
    public void testAddImport() throws HiLALocationSyntaxException {
	JobModel jb = new JobModel();

	//jb.addImport(null);
      jb.addImport(new File("/tmp/import"));

	Assert.assertNotNull(jb.getImports());
	Assert.assertEquals(1, jb.getImports().size());
    }

    @Test
    public void testGetExports() {
	JobModel jb = new JobModel();
	Assert.assertNotNull(jb.getExports());
	Assert.assertEquals(0, jb.getExports().size());
    }

    @Test
    public void testSetExports() {
	JobModel jb = new JobModel();
	Export imp = new Export(null, null);
	jb.setExports(Collections.singletonList(imp));

	Assert.assertNotNull(jb.getExports());
	Assert.assertEquals(1, jb.getExports().size());
	Assert.assertNull(jb.getExports().get(0).getSourcePath());
	Assert.assertNull(jb.getExports().get(0).getTargetFile());
    }

    @Test
   public void testAddExport() throws HiLALocationSyntaxException {
	JobModel jb = new JobModel();

	//jb.addExport(null);
      jb.addExport(new File("/tmp/export"));

	Assert.assertNotNull(jb.getExports());
	Assert.assertEquals(1, jb.getExports().size());
    }
    
    @Test
    public void testGetApplicationNameAndVersion() {
	String appName = "Date";
	String appVers = "1.0";
	String exec    = "/bin/date";
	
	JobModel jb = new JobModel();
	jb.setApplicationName(appName);
	jb.setApplicationVersion(appVers);
	
	Assert.assertNull(jb.getExecutable());
	Assert.assertEquals(appName, jb.getApplicationName());
	Assert.assertEquals(appVers, jb.getApplicationVersion());
	
	jb.setExecutable(exec);
	Assert.assertNull(jb.getApplicationName());
	Assert.assertEquals(exec, jb.getExecutable());
	
	
    }
    
    @Test
    public void testGetArguments() {
	JobModel jb = new JobModel();
	Assert.assertNotNull(jb.getArguments());
	Assert.assertEquals(0, jb.getArguments().size());
	jb.addArgument("test");
	Assert.assertEquals("test", jb.getArguments().get(0));
	
	
    }
    
    @Test
    public void testSetArguments() {
	JobModel jb = new JobModel();
	List<String> arguments = new ArrayList<String>();
	
	jb.setArguments(arguments);
	Assert.assertNotNull(jb.getArguments());
	Assert.assertEquals(arguments, jb.getArguments());
	
	
    }
   
    @Test
    public void testEnvironment() {
	JobModel jb = new JobModel();
	Assert.assertNotNull(jb.getEnvironment());
	Assert.assertEquals(0, jb.getEnvironment().size());
	
	jb.addEnvironment("name", "value");
	Assert.assertEquals(1, jb.getEnvironment().size());
	Assert.assertEquals("value", jb.getEnvironment().get("name"));
	
	
	
	Map<String, String> env = new HashMap<String, String>();
	jb.setEnvironment(env);
	Assert.assertNotNull(jb.getEnvironment());
	Assert.assertEquals(0, jb.getEnvironment().size());
	
	
    }
    
    @Test
    public void testTaskName() {
	String taskName = "Task XYZ";
	JobModel jb = new JobModel();
	Assert.assertNull(jb.getTaskName());
	
	jb.setTaskName(taskName);
	Assert.assertEquals(taskName, jb.getTaskName());
	
    }
}
