/*********************************************************************************
 * Copyright (c) 2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.job.emi;

import junit.framework.Assert;

import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ProcessorArchitectureEnumeration;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;
import org.junit.Test;

import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.job.model.JobModel;
import eu.unicore.hila.job.model.MappingFactory;
import eu.unicore.hila.job.spi.MappingFactorySpi;
import eu.unicore.hila.job.spi.ModelToNative;
import eu.unicore.hila.job.spi.NativeToModel;
import eu.unicore.hila.job.spi.NoSuchMappingException;

/**
 * @author bjoernh
 *
 * 21.12.2011 15:17:17
 *
 */
public class ModelToAdlTest {

   @Test
   public void testMapping() throws HiLAException, NoSuchMappingException {
      JobModel jm = new JobModel();

      jm.setExecutable("/bin/echo");
      jm.addArgument("Hello world");

      jm.addEnvironment("MPI", "mpich");

      // ModelToEmiAdl adl = new ModelToEmiAdl();
      // adl.setModel(jm);
      MappingFactorySpi mappingFactory = MappingFactory.getMapping("emi-adl");
      ModelToNative m2n = mappingFactory.createModelToNativeMapping(jm);

      System.out.println(m2n.getNative());
      Assert.assertTrue(((XmlObject) m2n.getNative()).validate());
   }

   @Test
   public void testResources() throws NoSuchMappingException, HiLAException {
      JobModel jm = new JobModel();

      // jm.setApplicationName("Date");
      // jm.setApplicationVersion("1.0");
      jm.setExecutable("/bin/echo");
      jm.addArgument("Hello world");

      ResourcesType res = ResourcesType.Factory.newInstance();

      res.addNewCPUArchitecture().setCPUArchitectureName(
            ProcessorArchitectureEnumeration.X_86_64);
      res.addNewIndividualCPUTime().addNewExact().setDoubleValue(10.0);
      res.addNewIndividualCPUCount().addNewExact().setDoubleValue(1.0);
      res.addNewTotalResourceCount().addNewExact().setDoubleValue(1.0);

      jm.setResources(res);

      MappingFactorySpi mf = MappingFactory.getMapping("emi-adl");
      ModelToNative m2n = mf.createModelToNativeMapping(jm);

      System.out.println(m2n.getNative());

      NativeToModel n2m = mf.createNativeToModelMapping(m2n.getNative());
      System.out.println(mf.createModelToNativeMapping(n2m.getModel())
            .getNative());

   }
}
