/*********************************************************************************
 * Copyright (c) 2009 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.common.grid;

import java.util.ArrayList;
import java.util.List;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.common.BaseResource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLAFactoryException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.grid.Job;
import eu.unicore.hila.grid.Site;
import eu.unicore.hila.grid.Storage;
import eu.unicore.hila.grid.job.JobDescription;
import eu.unicore.hila.job.model.MappingFactory;
import eu.unicore.hila.job.spi.NoSuchMappingException;

/**
 * @author bjoernh
 * 
 *         13.08.2009 10:00:55
 * 
 */
public abstract class BaseSite extends BaseResource implements Site {

    private volatile List<Resource> children;

    /**
     * @param _location
     */
    public BaseSite(Location _location) {
	super(_location);

    }

    /**
     * @see eu.unicore.hila.grid.Site#getStorages()
     */
    public List<Storage> getStorages() throws HiLAException {
	final List<Storage> storages = new ArrayList<Storage>();
	return storages;
    }

    /**
     * @throws HiLALocationSyntaxException 
     * @see eu.unicore.hila.Resource#getChildren()
     */
    public List<Resource> getChildren() throws HiLALocationSyntaxException {
	if (this.children == null) {
	    synchronized (this) {
		if (this.children == null) {
		    children = new ArrayList<Resource>();
		    Location tasksLocation = this.location
			    .getChildLocation("tasks");
		    Location storagesLocation = this.location
			    .getChildLocation("storages");

		    try {
                  final Resource tasks = tasksLocation.locate();
			children.add(tasks);
		    } catch (HiLAException e) {
			// unable to locate
		    }
		    try {
                  final Resource storages = storagesLocation.locate();
			children.add(storages);
		    } catch (HiLAException e) {
			// unable to locate
		    }

		}
	    }
	}

	return children;
    }

	         /**
    * This method is there for compatibility with versions of HiLA prior to
    * 2.3.0.
    * 
    * @deprecated in favor of
    *             {@link #submit(eu.unicore.hila.job.model.JobModel)}
    * 
    * @see eu.unicore.hila.grid.Submittable#submit(eu.unicore.hila.grid.job.JobDescription)
    */
	@Override
	public Job submit(JobDescription _jd) throws HiLAException {
		if (_jd.getActualJobDescription() instanceof JobDefinitionDocument) {
			JobDefinitionDocument jsdl = (JobDefinitionDocument) _jd
					.getActualJobDescription();
         try {
            return submit(MappingFactory.getMapping("jsdl")
                  .createNativeToModelMapping(jsdl).getModel());
         } catch (NoSuchMappingException e) {
            throw new HiLAException(
                  "Unable to map input JobDescription to the job model.", e);
         }
		}
		throw new HiLAFactoryException(
				"Unable to map input JobDescription to the job model.");
	}

}
